/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.secret;

import dev.vality.adapter.common.exception.HexDecodeException;
import dev.vality.adapter.common.secret.HmacAlgorithms;
import dev.vality.adapter.common.secret.SecretRef;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacUtils;

class HmacSigner {
    HmacSigner() {
    }

    public String sign(String data, String hexSecret, SecretRef secretRef, HmacAlgorithms hmacAlgorithm) throws HexDecodeException {
        try {
            byte[] key = Hex.decodeHex((String)hexSecret);
            return new HmacUtils(hmacAlgorithm.getName(), key).hmacHex(data);
        }
        catch (DecoderException e) {
            throw new HexDecodeException(secretRef.toString());
        }
    }
}

