/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.damsel;

import dev.vality.damsel.domain.BankCard;
import dev.vality.damsel.domain.ContactInfo;
import dev.vality.damsel.domain.DisposablePaymentResource;
import dev.vality.damsel.domain.PaymentTool;
import dev.vality.damsel.domain.TargetInvoicePaymentStatus;
import dev.vality.damsel.domain.TransactionInfo;
import dev.vality.damsel.proxy_provider.Cash;
import dev.vality.damsel.proxy_provider.PaymentContext;
import dev.vality.damsel.proxy_provider.PaymentInfo;
import dev.vality.damsel.proxy_provider.PaymentResource;
import dev.vality.damsel.proxy_provider.RecurrentPaymentResource;
import dev.vality.damsel.proxy_provider.RecurrentTokenContext;
import java.util.Map;

public class ProxyProviderPackageExtractors {
    public static DisposablePaymentResource extractDisposablePaymentResource(RecurrentTokenContext context) {
        return context.getTokenInfo().getPaymentTool().getPaymentResource();
    }

    public static DisposablePaymentResource extractDisposablePaymentResource(PaymentContext context) {
        return context.getPaymentInfo().getPayment().getPaymentResource().getDisposablePaymentResource();
    }

    public static PaymentResource extractPaymentResource(PaymentContext context) {
        return context.getPaymentInfo().getPayment().getPaymentResource();
    }

    public static String extractRecurrentId(RecurrentTokenContext context) {
        return context.getTokenInfo().getPaymentTool().getId();
    }

    public static String extractInvoiceId(PaymentContext context) {
        return ProxyProviderPackageExtractors.extractInvoiceId(context.getPaymentInfo());
    }

    public static String extractInvoiceId(PaymentInfo paymentInfo) {
        return paymentInfo.getInvoice().getId();
    }

    public static String extractPaymentId(PaymentContext context) {
        return ProxyProviderPackageExtractors.extractPaymentId(context.getPaymentInfo());
    }

    public static String extractPaymentId(PaymentInfo paymentInfo) {
        return paymentInfo.getPayment().getId();
    }

    public static String extractRecurrentToken(PaymentContext context) {
        return context.getPaymentInfo().getPayment().getPaymentResource().getRecurrentPaymentResource().getRecToken();
    }

    public static BankCard extractBankCard(RecurrentTokenContext context) {
        return ProxyProviderPackageExtractors.extractBankCard(context.getTokenInfo().getPaymentTool().getPaymentResource());
    }

    public static BankCard extractBankCard(PaymentContext context) {
        return ProxyProviderPackageExtractors.extractBankCard(context.getPaymentInfo().getPayment().getPaymentResource());
    }

    public static BankCard extractBankCard(PaymentInfo paymentInfo) {
        return ProxyProviderPackageExtractors.extractBankCard(paymentInfo.getPayment().getPaymentResource());
    }

    public static BankCard extractBankCard(PaymentResource paymentResource) {
        if (paymentResource.isSetDisposablePaymentResource()) {
            return ProxyProviderPackageExtractors.extractBankCard(paymentResource.getDisposablePaymentResource());
        }
        return ProxyProviderPackageExtractors.extractBankCard(paymentResource.getRecurrentPaymentResource());
    }

    public static BankCard extractBankCard(RecurrentPaymentResource paymentResource) {
        return paymentResource.getPaymentTool().getBankCard();
    }

    public static BankCard extractBankCard(DisposablePaymentResource paymentResource) {
        return paymentResource.getPaymentTool().getBankCard();
    }

    public static String extractBankCardToken(PaymentResource paymentResource) {
        if (paymentResource.isSetDisposablePaymentResource()) {
            return ProxyProviderPackageExtractors.extractBankCardToken(paymentResource.getDisposablePaymentResource());
        }
        return ProxyProviderPackageExtractors.extractBankCardToken(paymentResource.getRecurrentPaymentResource());
    }

    public static String extractBankCardToken(RecurrentPaymentResource paymentResource) {
        return paymentResource.getPaymentTool().getBankCard().getToken();
    }

    public static String extractBankCardToken(DisposablePaymentResource paymentResource) {
        return paymentResource.getPaymentTool().getBankCard().getToken();
    }

    public static ContactInfo extractPaymentInfo(PaymentContext context) {
        return context.getPaymentInfo().getPayment().getContactInfo();
    }

    public static Cash extractCashPayment(PaymentContext context) {
        return context.getPaymentInfo().getPayment().getCost();
    }

    public static Cash extractCashRefund(PaymentContext context) {
        return context.getPaymentInfo().getRefund().getCash();
    }

    public static Cash extractCashRecurrentToken(RecurrentTokenContext context) {
        return context.getTokenInfo().getPaymentTool().getMinimalPaymentCost();
    }

    public static Map<String, String> extractTrxExtra(PaymentContext context) {
        return context.getPaymentInfo().getPayment().getTrx().getExtra();
    }

    public static TransactionInfo extractTransactionInfo(PaymentContext context) {
        return context.getPaymentInfo().getPayment().getTrx();
    }

    public static String extractTargetInvoicePaymentStatus(PaymentContext paymentContext) {
        return ProxyProviderPackageExtractors.extractTargetInvoicePaymentStatus(paymentContext.getSession().getTarget());
    }

    public static String extractTargetInvoicePaymentStatus(TargetInvoicePaymentStatus targetInvoicePaymentStatus) {
        String state = "unknown";
        if (targetInvoicePaymentStatus.isSetProcessed()) {
            state = TargetInvoicePaymentStatus._Fields.PROCESSED.getFieldName();
        } else if (targetInvoicePaymentStatus.isSetCaptured()) {
            state = TargetInvoicePaymentStatus._Fields.CAPTURED.getFieldName();
        } else if (targetInvoicePaymentStatus.isSetCancelled()) {
            state = TargetInvoicePaymentStatus._Fields.CANCELLED.getFieldName();
        } else if (targetInvoicePaymentStatus.isSetRefunded()) {
            state = TargetInvoicePaymentStatus._Fields.REFUNDED.getFieldName();
        }
        return state.toUpperCase();
    }

    public static PaymentTool extractPaymentTool(PaymentResource paymentResource) {
        if (paymentResource.isSetDisposablePaymentResource()) {
            return paymentResource.getDisposablePaymentResource().getPaymentTool();
        }
        if (paymentResource.isSetRecurrentPaymentResource()) {
            return paymentResource.getRecurrentPaymentResource().getPaymentTool();
        }
        throw new RuntimeException("Unknown Payment Resource");
    }

    private ProxyProviderPackageExtractors() {
    }
}

