/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.component;

import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.api.trace.context.TraceContext;
import java.time.Duration;
import java.util.List;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.springframework.boot.actuate.metrics.web.client.ObservationRestTemplateCustomizer;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class RestTemplateComponent {
    public RestTemplate getSimpleRestTemplate(ObservationRestTemplateCustomizer observationRestTemplateCustomizer, int networkTimeout) {
        HttpComponentsClientHttpRequestFactory requestFactory = this.getRequestFactory(this.getSimpleHttpClient());
        RestTemplateBuilder restTemplateBuilder = this.getRestTemplateBuilder(requestFactory, observationRestTemplateCustomizer);
        return this.getRestTemplate(restTemplateBuilder, networkTimeout);
    }

    public RestTemplate getRestTemplateWithConverters(ObservationRestTemplateCustomizer observationRestTemplateCustomizer, List<HttpMessageConverter<?>> messageConverterList, int networkTimeout) {
        HttpComponentsClientHttpRequestFactory requestFactory = this.getRequestFactory(this.getSimpleHttpClient());
        RestTemplateBuilder restTemplateBuilder = this.getRestTemplateBuilder(requestFactory, observationRestTemplateCustomizer);
        RestTemplate restTemplate = this.getRestTemplate(restTemplateBuilder, networkTimeout);
        restTemplate.setMessageConverters(messageConverterList);
        return restTemplate;
    }

    public RestTemplate getRestTemplate(RestTemplateBuilder restTemplateBuilder, int networkTimeout) {
        int executionTimeout = ContextUtils.getExecutionTimeout((ContextSpan)TraceContext.getCurrentTraceData().getServiceSpan(), (int)networkTimeout);
        return restTemplateBuilder.setConnectTimeout(Duration.ofMillis(executionTimeout)).setReadTimeout(Duration.ofMillis(executionTimeout)).build();
    }

    public RestTemplateBuilder getRestTemplateBuilder(HttpComponentsClientHttpRequestFactory requestFactory, ObservationRestTemplateCustomizer observationRestTemplateCustomizer) {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(() -> requestFactory).additionalCustomizers(new RestTemplateCustomizer[]{observationRestTemplateCustomizer});
    }

    public HttpComponentsClientHttpRequestFactory getRequestFactory(CloseableHttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        return requestFactory;
    }

    public CloseableHttpClient getSimpleHttpClient() {
        return HttpClients.custom().disableAutomaticRetries().build();
    }
}

