/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.component;

import dev.vality.adapter.common.logging.GetLogging;
import dev.vality.adapter.common.logging.PostLogging;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@Aspect
public class RequestLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestLoggingAspect.class);
    private static final String REQUEST_LOG = "Request [{} {}]: {}";
    private static final String RESPONSE_LOG = "Response [{} {}]: {}";

    @Around(value="@annotation(dev.vality.adapter.common.logging.GetLogging)")
    public Object logGetRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        GetLogging getLogging = (GetLogging)AnnotationUtils.findAnnotation((Method)signature.getMethod(), GetLogging.class);
        RequestMethod method = getLogging.method();
        String endpoint = getLogging.value();
        return this.log(joinPoint, method, endpoint);
    }

    @Around(value="@annotation(dev.vality.adapter.common.logging.PostLogging)")
    public Object logPostRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        PostLogging postLogging = (PostLogging)AnnotationUtils.findAnnotation((Method)signature.getMethod(), PostLogging.class);
        RequestMethod method = postLogging.method();
        String endpoint = postLogging.value();
        return this.log(joinPoint, method, endpoint);
    }

    private Object log(ProceedingJoinPoint joinPoint, RequestMethod method, String endpoint) throws Throwable {
        if (joinPoint.getArgs().length != 1) {
            log.debug("Unable to log request. Unsupported method signature with more than one argument: {}", joinPoint.getArgs());
            return joinPoint.proceed();
        }
        Object request = joinPoint.getArgs()[0];
        log.info(REQUEST_LOG, new Object[]{method, endpoint, request});
        Object response = joinPoint.proceed();
        log.info(RESPONSE_LOG, new Object[]{method, endpoint, response});
        return response;
    }
}

