/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.component;

import dev.vality.woody.api.flow.WFlow;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.web.filter.OncePerRequestFilter;

public class NetworkFilterComponent {
    public static final String HEALTH = "/actuator/health";

    public FilterRegistrationBean externalPortRestrictingFilter(final int restPort, final String restEndpoint) {
        OncePerRequestFilter filter = new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                String servletPath = request.getServletPath();
                if (request.getLocalPort() == restPort && !servletPath.startsWith(restEndpoint) && !servletPath.startsWith(NetworkFilterComponent.HEALTH)) {
                    response.sendError(404, "Unknown address");
                    return;
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        };
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)filter);
        filterRegistrationBean.setOrder(-100);
        filterRegistrationBean.setName("httpPortFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        return filterRegistrationBean;
    }

    public FilterRegistrationBean woodyFilter(final int restPort, final String restEndpoint) {
        final WFlow woodyFlow = new WFlow();
        OncePerRequestFilter filter = new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                if (request.getLocalPort() == restPort && request.getServletPath().startsWith(restEndpoint)) {
                    woodyFlow.createServiceFork(() -> {
                        try {
                            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                        }
                        catch (ServletException | IOException e) {
                            this.sneakyThrow(e);
                        }
                    }).run();
                    return;
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }

            private <E extends Throwable, T> T sneakyThrow(Throwable t) throws E {
                throw t;
            }
        };
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)filter);
        filterRegistrationBean.setOrder(-50);
        filterRegistrationBean.setName("woodyFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{restEndpoint + "*"});
        return filterRegistrationBean;
    }
}

