/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.cds;

import dev.vality.cds.storage.Auth3DS;
import dev.vality.cds.storage.AuthData;
import dev.vality.cds.storage.CardData;
import dev.vality.cds.storage.CardSecurityCode;
import dev.vality.cds.storage.ExpDate;
import dev.vality.cds.storage.SessionData;

public class CdsPackageCreators {
    public static CardData createCardData(String pan) {
        return new CardData().setPan(pan);
    }

    public static CardData createCardData(String pan, String cardHolderName) {
        return CdsPackageCreators.createCardData(pan).setCardholderName(cardHolderName);
    }

    public static CardData createCardDataWithExpDate(String pan, String cardHolderName, String month, String year) {
        return CdsPackageCreators.createCardData(pan, cardHolderName).setExpDate(CdsPackageCreators.createExpDate(month, year));
    }

    public static ExpDate createExpDate(String month, String year) {
        return new ExpDate().setMonth(Byte.valueOf(month).byteValue()).setYear(Short.valueOf(year).shortValue());
    }

    public static SessionData createSessionData(AuthData authData) {
        return new SessionData(authData);
    }

    public static SessionData createSessionDataWithCvv(String cvv) {
        return new SessionData(CdsPackageCreators.createAuthDataWithCardSecurityCode(cvv));
    }

    public static SessionData createSessionDataWithCryptogramAndEci(String cryptogram, String eci) {
        return new SessionData(CdsPackageCreators.createAuthDataWithCryptogramAndEci(cryptogram, eci));
    }

    public static AuthData createAuthData(CardSecurityCode cardSecurityCode) {
        return AuthData.card_security_code((CardSecurityCode)cardSecurityCode);
    }

    public static AuthData createAuthDataWithAuth3DS(Auth3DS auth3DS) {
        return AuthData.auth_3ds((Auth3DS)auth3DS);
    }

    public static Auth3DS createAuth3DS(String cryptogram) {
        return CdsPackageCreators.createAuth3DS(cryptogram, null);
    }

    public static Auth3DS createAuth3DS(String cryptogram, String eci) {
        return new Auth3DS(cryptogram).setEci(eci);
    }

    public static AuthData createAuthDataWithCryptogramAndEci(String cryptogram, String eci) {
        return AuthData.auth_3ds((Auth3DS)CdsPackageCreators.createAuth3DS(cryptogram, eci));
    }

    public static AuthData createAuthDataWithCardSecurityCode(String cvv) {
        return AuthData.card_security_code((CardSecurityCode)new CardSecurityCode(cvv));
    }

    private CdsPackageCreators() {
    }
}

