/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.cds;

import dev.vality.adapter.common.exception.CdsIDStorageException;
import dev.vality.damsel.identity_document_storage.IdentityDocument;
import dev.vality.damsel.identity_document_storage.IdentityDocumentStorageSrv;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsIdStorageClient {
    private static final Logger log = LoggerFactory.getLogger(CdsIdStorageClient.class);
    private final IdentityDocumentStorageSrv.Iface cdsIDStorageApi;

    public IdentityDocument get(String token) {
        log.info("Get Identity Document by token: {}", (Object)token);
        try {
            return this.cdsIDStorageApi.get(token);
        }
        catch (TException ex) {
            throw new CdsIDStorageException(String.format("Failed to get identity document from cds storage with token: %s", token), ex);
        }
    }

    public CdsIdStorageClient(IdentityDocumentStorageSrv.Iface cdsIDStorageApi) {
        this.cdsIDStorageApi = cdsIDStorageApi;
    }
}

