/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.cds;

import com.github.javafaker.Faker;
import com.github.javafaker.Name;
import dev.vality.adapter.common.cds.model.CardDataProxyModel;
import dev.vality.adapter.common.exception.CdsStorageExpDateException;
import dev.vality.cds.storage.CardData;
import dev.vality.damsel.domain.BankCard;
import java.util.List;
import java.util.Locale;
import org.springframework.util.CollectionUtils;

public class BankCardExtractor {
    private static final Name FAKER_NAME = new Faker(Locale.ENGLISH).name();
    private static final String NAME_REGEXP = "[^a-zA-Z +]";

    public static CardDataProxyModel initCardDataProxyModel(BankCard bankCard, CardData cardData) {
        return BankCardExtractor.initCardDataProxyModel(bankCard, cardData, null);
    }

    public static CardDataProxyModel initCardDataProxyModel(BankCard bankCard, CardData cardData, List<String> cardHoldersNames) {
        String cardHolder = BankCardExtractor.extractCardHolder(bankCard, cardData, cardHoldersNames);
        if (!bankCard.isSetExpDate() && !cardData.isSetExpDate()) {
            throw new CdsStorageExpDateException("Expiration date not found");
        }
        return CardDataProxyModel.builder().cardholderName(cardHolder).pan(cardData.getPan()).expMonth(bankCard.isSetExpDate() ? bankCard.getExpDate().getMonth() : cardData.getExpDate().getMonth()).expYear(bankCard.isSetExpDate() ? bankCard.getExpDate().getYear() : cardData.getExpDate().getYear()).build();
    }

    private static String extractCardHolder(BankCard bankCard, CardData cardData, List<String> cardHoldersNames) {
        if (bankCard.isSetCardholderName()) {
            return bankCard.getCardholderName();
        }
        if (cardData.isSetCardholderName()) {
            return cardData.getCardholderName();
        }
        if (!CollectionUtils.isEmpty(cardHoldersNames)) {
            return BankCardExtractor.getCardHolderFromList(cardHoldersNames, bankCard.getToken());
        }
        return (FAKER_NAME.firstName() + " " + FAKER_NAME.lastName()).replaceAll(NAME_REGEXP, "").toUpperCase();
    }

    private static String getCardHolderFromList(List<String> cardHoldersNames, String cardToken) {
        return cardHoldersNames.get(Math.abs(cardToken.hashCode() % cardHoldersNames.size()));
    }

    public static CardDataProxyModel initCardDataProxyModelWithOptionalExpDate(BankCard bankCard, CardData cardData) {
        String cardHolder = BankCardExtractor.extractCardHolder(bankCard, cardData, null);
        return CardDataProxyModel.builder().cardholderName(cardHolder).pan(cardData.getPan()).expMonth(BankCardExtractor.getExpMonth(bankCard, cardData)).expYear(BankCardExtractor.getExpYear(bankCard, cardData)).build();
    }

    private static byte getExpMonth(BankCard bankCard, CardData cardData) {
        if (bankCard.isSetExpDate()) {
            return bankCard.getExpDate().getMonth();
        }
        return cardData.isSetExpDate() ? cardData.getExpDate().getMonth() : (byte)0;
    }

    private static short getExpYear(BankCard bankCard, CardData cardData) {
        if (bankCard.isSetExpDate()) {
            return bankCard.getExpDate().getYear();
        }
        return cardData.isSetExpDate() ? cardData.getExpDate().getYear() : (short)0;
    }

    private BankCardExtractor() {
    }
}

