/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.bender;

import dev.vality.adapter.common.exception.BenderException;
import dev.vality.bender.BenderSrv;
import dev.vality.bender.ConstantSchema;
import dev.vality.bender.GenerationResult;
import dev.vality.bender.GenerationSchema;
import dev.vality.bender.GetInternalIDResult;
import dev.vality.bender.SequenceSchema;
import dev.vality.bender.SnowflakeSchema;
import dev.vality.msgpack.Nil;
import dev.vality.msgpack.Value;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenderClient {
    private static final Logger log = LoggerFactory.getLogger(BenderClient.class);
    private final BenderSrv.Iface benderSrv;
    private final String namespace;

    public GenerationResult generateId(String externalID, GenerationSchema generationSchema, Value context) {
        log.info("GenerateId with externalID='{}', generationSchema='{}'", (Object)externalID, (Object)generationSchema);
        try {
            return this.benderSrv.generateID(externalID, generationSchema, context);
        }
        catch (TException ex) {
            throw new BenderException(String.format("Can't generateId with externalID='%s', generationSchema='%s'", externalID, generationSchema), ex);
        }
    }

    public GetInternalIDResult getInternalID(String externalID) {
        log.info("Get Internal ID with externalID='{}'", (Object)externalID);
        try {
            return this.benderSrv.getInternalID(externalID);
        }
        catch (TException ex) {
            throw new BenderException(String.format("Can't Get Internal ID with externalID='%s'", externalID), ex);
        }
    }

    public GenerationResult generateIdWithSequenceSchema(String externalID) {
        return this.generateIdWithSequenceSchema(externalID, this.namespace, null, Value.nl((Nil)new Nil()));
    }

    public GenerationResult generateIdWithSequenceSchema(String externalID, String namespace) {
        return this.generateIdWithSequenceSchema(externalID, namespace, null, Value.nl((Nil)new Nil()));
    }

    public GenerationResult generateIdWithSequenceSchema(String externalID, String namespace, Long sequenceMinimum) {
        return this.generateIdWithSequenceSchema(externalID, namespace, sequenceMinimum, Value.nl((Nil)new Nil()));
    }

    public GenerationResult generateIdWithSequenceSchema(String externalID, String namespace, Value context) {
        return this.generateIdWithSequenceSchema(externalID, namespace, null, context);
    }

    public GenerationResult generateIdWithSequenceSchema(String externalID, String namespace, Long sequenceMinimum, Value context) {
        SequenceSchema sequenceSchema = new SequenceSchema();
        sequenceSchema.setSequenceId(namespace);
        if (sequenceMinimum != null) {
            sequenceSchema.setMinimum(sequenceMinimum.longValue());
        }
        GenerationSchema generationSchema = GenerationSchema.sequence((SequenceSchema)sequenceSchema);
        return this.generateId(externalID, generationSchema, context);
    }

    public GenerationResult generateIdWithConstantSchema(String externalID, String internalId) {
        return this.generateIdWithConstantSchema(externalID, internalId, Value.nl((Nil)new Nil()));
    }

    public GenerationResult generateIdWithConstantSchema(String externalID, String internalId, Value context) {
        ConstantSchema constantSchema = new ConstantSchema().setInternalId(internalId);
        GenerationSchema generationSchema = GenerationSchema.constant((ConstantSchema)constantSchema);
        return this.generateId(externalID, generationSchema, context);
    }

    public GenerationResult generateIdWithSnowflakeSchema(String externalID, Value context) {
        GenerationSchema generationSchema = GenerationSchema.snowflake((SnowflakeSchema)new SnowflakeSchema());
        return this.generateId(externalID, generationSchema, context);
    }

    public GenerationResult generateIdWithSnowflakeSchema(String externalID) {
        return this.generateIdWithSnowflakeSchema(externalID, Value.nl((Nil)new Nil()));
    }

    public BenderClient(BenderSrv.Iface benderSrv, String namespace) {
        this.benderSrv = benderSrv;
        this.namespace = namespace;
    }
}

