/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.bank.payout.spring.boot.starter.service;

import dev.vality.adapter.common.damsel.ProxyProviderVerification;
import dev.vality.damsel.msgpack.Value;
import dev.vality.damsel.withdrawals.provider_adapter.AdapterSrv;
import dev.vality.damsel.withdrawals.provider_adapter.Callback;
import dev.vality.damsel.withdrawals.provider_adapter.CallbackResult;
import dev.vality.damsel.withdrawals.provider_adapter.GetQuoteFailure;
import dev.vality.damsel.withdrawals.provider_adapter.GetQuoteParams;
import dev.vality.damsel.withdrawals.provider_adapter.ProcessResult;
import dev.vality.damsel.withdrawals.provider_adapter.Quote;
import dev.vality.damsel.withdrawals.provider_adapter.Withdrawal;
import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayoutAdapterServiceLogDecorator
implements AdapterSrv.Iface {
    private static final Logger log = LoggerFactory.getLogger(PayoutAdapterServiceLogDecorator.class);
    private final AdapterSrv.Iface payoutAdapterService;

    public ProcessResult processWithdrawal(Withdrawal withdrawal, Value state, Map<String, String> options) throws TException {
        String withdrawalId = withdrawal.getId();
        log.info("processWithdrawal: start with withdrawalId {}", (Object)withdrawalId);
        try {
            ProcessResult processResult = this.payoutAdapterService.processWithdrawal(withdrawal, state, options);
            log.info("processWithdrawal: finish {} with withdrawalId {}", (Object)processResult, (Object)withdrawalId);
            return processResult;
        }
        catch (Exception ex) {
            String message = "Exception in processWithdrawal with withdrawalId " + withdrawalId;
            this.logMessage(ex, message);
            throw ex;
        }
    }

    public Quote getQuote(GetQuoteParams getQuoteParams, Map<String, String> map) throws GetQuoteFailure, TException {
        String withdrawalId = getQuoteParams.getIdempotencyId();
        log.info("getQuote: start with withdrawalId {}", (Object)withdrawalId);
        try {
            Quote quote = this.payoutAdapterService.getQuote(getQuoteParams, map);
            log.info("getQuote: finish {} with withdrawalId {}", (Object)quote, (Object)withdrawalId);
            return quote;
        }
        catch (Exception ex) {
            String message = "Exception in getQuote with withdrawalId " + withdrawalId;
            this.logMessage(ex, message);
            throw ex;
        }
    }

    public CallbackResult handleCallback(Callback callback, Withdrawal withdrawal, Value value, Map<String, String> map) throws TException {
        String withdrawalId = withdrawal.getId();
        log.info("handleCallback: start with withdrawalId {}", (Object)withdrawalId);
        try {
            CallbackResult callbackResult = this.payoutAdapterService.handleCallback(callback, withdrawal, value, map);
            log.info("handleCallback: finish {} with withdrawalId {}", (Object)callbackResult, (Object)withdrawalId);
            return callbackResult;
        }
        catch (Exception ex) {
            String message = "Exception in handleCallback with withdrawalId " + withdrawalId;
            this.logMessage(ex, message);
            throw ex;
        }
    }

    private void logMessage(Exception ex, String message) {
        if (ProxyProviderVerification.isUndefinedResultOrUnavailable((Exception)ex)) {
            log.warn(message, (Throwable)ex);
        } else {
            log.error(message, (Throwable)ex);
        }
    }

    public PayoutAdapterServiceLogDecorator(AdapterSrv.Iface payoutAdapterService) {
        this.payoutAdapterService = payoutAdapterService;
    }
}

