/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.bank.payout.spring.boot.starter.service;

import dev.vality.adapter.bank.payout.spring.boot.starter.converter.ExitStateToProcessResultConverter;
import dev.vality.adapter.bank.payout.spring.boot.starter.converter.WithdrawalToEntryStateConverter;
import dev.vality.adapter.bank.payout.spring.boot.starter.exception.UnsupportedMethodException;
import dev.vality.adapter.bank.payout.spring.boot.starter.flow.StepResolver;
import dev.vality.adapter.bank.payout.spring.boot.starter.handler.CommonHandler;
import dev.vality.adapter.bank.payout.spring.boot.starter.handler.GetQuoteHandler;
import dev.vality.adapter.bank.payout.spring.boot.starter.handler.HandleCallbackHandler;
import dev.vality.adapter.bank.payout.spring.boot.starter.model.EntryStateModel;
import dev.vality.adapter.bank.payout.spring.boot.starter.model.ExitStateModel;
import dev.vality.adapter.bank.payout.spring.boot.starter.validator.WithdrawalValidator;
import dev.vality.damsel.msgpack.Value;
import dev.vality.damsel.withdrawals.provider_adapter.AdapterSrv;
import dev.vality.damsel.withdrawals.provider_adapter.Callback;
import dev.vality.damsel.withdrawals.provider_adapter.CallbackResult;
import dev.vality.damsel.withdrawals.provider_adapter.GetQuoteFailure;
import dev.vality.damsel.withdrawals.provider_adapter.GetQuoteParams;
import dev.vality.damsel.withdrawals.provider_adapter.ProcessResult;
import dev.vality.damsel.withdrawals.provider_adapter.Quote;
import dev.vality.damsel.withdrawals.provider_adapter.Withdrawal;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayoutAdapterService<T extends EntryStateModel, X extends ExitStateModel>
implements AdapterSrv.Iface {
    private static final Logger log = LoggerFactory.getLogger(PayoutAdapterService.class);
    private final WithdrawalToEntryStateConverter<T> withdrawalToEntryStateConverter;
    private final ExitStateToProcessResultConverter<X> exitStateToProcessResultConverter;
    private final List<CommonHandler<T, X>> handlers;
    private final StepResolver<T, X> resolver;
    private final WithdrawalValidator validator;
    private final GetQuoteHandler getQuoteHandler;
    private final HandleCallbackHandler handleCallbackHandler;

    public ProcessResult processWithdrawal(Withdrawal withdrawal, Value state, Map<String, String> options) throws TException {
        this.validator.validate(withdrawal, state, options);
        Object entryStateModel = this.withdrawalToEntryStateConverter.convert(withdrawal, state, options);
        log.info("EntryStateModel: {}", entryStateModel);
        ((EntryStateModel)entryStateModel).getState().setStep(this.resolver.resolveEntry(entryStateModel));
        Object exitStateModel = this.handlers.stream().filter(h -> h.isHandle(entryStateModel)).findFirst().orElseThrow(UnsupportedMethodException::new).handle(entryStateModel);
        log.info("ExitStateModel: {}", exitStateModel);
        ((ExitStateModel)exitStateModel).getNextState().setStep(this.resolver.resolveExit(exitStateModel));
        log.info("Step changing: {} -> {}", (Object)((EntryStateModel)entryStateModel).getState().getStep(), (Object)((ExitStateModel)exitStateModel).getNextState().getStep());
        return this.exitStateToProcessResultConverter.convert(exitStateModel);
    }

    public Quote getQuote(GetQuoteParams getQuoteParams, Map<String, String> map) throws GetQuoteFailure, TException {
        return this.getQuoteHandler.handle(getQuoteParams, map);
    }

    public CallbackResult handleCallback(Callback callback, Withdrawal withdrawal, Value value, Map<String, String> map) throws TException {
        return this.handleCallbackHandler.handleCallback(callback, withdrawal, value, map);
    }

    public PayoutAdapterService(WithdrawalToEntryStateConverter<T> withdrawalToEntryStateConverter, ExitStateToProcessResultConverter<X> exitStateToProcessResultConverter, List<CommonHandler<T, X>> handlers, StepResolver<T, X> resolver, WithdrawalValidator validator, GetQuoteHandler getQuoteHandler, HandleCallbackHandler handleCallbackHandler) {
        this.withdrawalToEntryStateConverter = withdrawalToEntryStateConverter;
        this.exitStateToProcessResultConverter = exitStateToProcessResultConverter;
        this.handlers = handlers;
        this.resolver = resolver;
        this.validator = validator;
        this.getQuoteHandler = getQuoteHandler;
        this.handleCallbackHandler = handleCallbackHandler;
    }
}

