/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.bank.payout.spring.boot.starter.service;

import dev.vality.adapter.bank.payout.spring.boot.starter.config.properties.TimerProperties;
import dev.vality.adapter.bank.payout.spring.boot.starter.model.EntryStateModel;
import dev.vality.adapter.bank.payout.spring.boot.starter.model.ExitStateModel;
import dev.vality.adapter.bank.payout.spring.boot.starter.service.IntentService;
import dev.vality.adapter.common.utils.times.ExponentialBackOffPollingService;
import dev.vality.damsel.domain.Failure;
import dev.vality.damsel.domain.TransactionInfo;
import dev.vality.damsel.withdrawals.provider_adapter.FinishIntent;
import dev.vality.damsel.withdrawals.provider_adapter.FinishStatus;
import dev.vality.damsel.withdrawals.provider_adapter.Intent;
import dev.vality.damsel.withdrawals.provider_adapter.Success;
import dev.vality.error.mapping.ErrorMapping;
import dev.vality.java.damsel.utils.creators.WithdrawalsProviderAdapterPackageCreators;
import dev.vality.java.damsel.utils.extractors.OptionsExtractors;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class IntentServiceImpl
implements IntentService {
    private final ErrorMapping errorMapping;
    private final TimerProperties timerProperties;

    @Override
    public Intent getFailureByCode(ExitStateModel exitStateModel) {
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.failure((Failure)this.errorMapping.mapFailure(exitStateModel.getErrorCode()))));
    }

    @Override
    public Intent getFailureByCodeAndDesc(ExitStateModel exitStateModel) {
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.failure((Failure)this.errorMapping.mapFailure(exitStateModel.getErrorCode(), exitStateModel.getErrorMessage()))));
    }

    @Override
    public Intent getSuccess(ExitStateModel exitStateModel) {
        dev.vality.adapter.bank.payout.spring.boot.starter.model.TransactionInfo trxInfo = exitStateModel.getNextState().getTrxInfo();
        Success success = new Success();
        success.setTrxInfo(new TransactionInfo().setId(trxInfo.getTrxId()).setExtra(trxInfo.getTrxExtra()));
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.success((Success)success)));
    }

    @Override
    public Intent getSleep(ExitStateModel exitStateModel) {
        Instant maxDateTimePolling = exitStateModel.getNextState().getPollingInfo().getMaxDateTimePolling();
        if (maxDateTimePolling == null) {
            throw new IllegalArgumentException("Need to specify 'maxDateTimePolling' before sleep");
        }
        if (maxDateTimePolling.toEpochMilli() < Instant.now().toEpochMilli()) {
            return this.prepareFailureIntent();
        }
        int timerPollingDelay = this.computePollingInterval(exitStateModel);
        return WithdrawalsProviderAdapterPackageCreators.createIntentWithSleepIntent((Integer)timerPollingDelay);
    }

    private Intent prepareFailureIntent() {
        String code = "Sleep timeout";
        String reason = "Max time pool limit reached";
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.failure((Failure)this.errorMapping.mapFailure(code, reason))));
    }

    private int computePollingInterval(ExitStateModel exitStateModel) {
        ExponentialBackOffPollingService pollingService = new ExponentialBackOffPollingService();
        return pollingService.prepareNextPollingInterval(exitStateModel.getNextState().getPollingInfo(), exitStateModel.getEntryStateModel().getOptions());
    }

    @Override
    public Long getMaxDateTimeInstantMillis(EntryStateModel entryStateModel) {
        int maxTimePolling = OptionsExtractors.extractMaxTimePolling(entryStateModel.getOptions(), (int)this.timerProperties.getMaxTimePolling());
        return Instant.now().plus((long)maxTimePolling, ChronoUnit.MINUTES).toEpochMilli();
    }

    @Override
    public Instant extractMaxDateTimeInstant(EntryStateModel entryStateModel) {
        int maxTimePolling = OptionsExtractors.extractMaxTimePolling(entryStateModel.getOptions(), (int)this.timerProperties.getMaxTimePolling());
        return Instant.now().plus((long)maxTimePolling, ChronoUnit.MINUTES);
    }

    public IntentServiceImpl(ErrorMapping errorMapping, TimerProperties timerProperties) {
        this.errorMapping = errorMapping;
        this.timerProperties = timerProperties;
    }
}

