/*
 * Decompiled with CFR 0.152.
 */
package dev.uni_hamburg.security.otp;

import dev.uni_hamburg.security.otp.Totp;
import dev.uni_hamburg.security.otp.api.Clock;

public final class TimeDriftTotp
extends Totp {
    private final String secret;
    private final int lookAheadInterval;
    private final int lookBehindInterval;
    private final Clock clock;
    private static final int MAX_TIME_DRIFT_TRAINING = 60;
    private int timeDriftCorrection;

    public TimeDriftTotp(String secret) {
        this(secret, new Clock());
    }

    public TimeDriftTotp(String secret, Clock clock) {
        this(secret, clock, 0, 1);
    }

    public TimeDriftTotp(String secret, int lookAheadInterval, int lookBehindInterval) {
        this(secret, lookAheadInterval, lookBehindInterval, 0);
    }

    public TimeDriftTotp(String secret, int lookAheadInterval, int lookBehindInterval, int timeDriftCorrection) {
        this(secret, new Clock(), lookAheadInterval, lookBehindInterval, timeDriftCorrection);
    }

    public TimeDriftTotp(String secret, Clock clock, int lookAheadInterval, int lookBehindInterval) {
        this(secret, clock, lookAheadInterval, lookBehindInterval, 0);
    }

    public TimeDriftTotp(String secret, Clock clock, int lookAheadInterval, int lookBehindInterval, int timeDriftCorrection) {
        super(secret, clock);
        this.secret = secret;
        this.clock = clock;
        this.lookAheadInterval = lookAheadInterval;
        this.lookBehindInterval = lookBehindInterval;
        this.timeDriftCorrection = timeDriftCorrection;
    }

    private boolean _verify(String otp, boolean train) {
        long code = Long.parseLong(otp);
        long currentInterval = this.clock.getCurrentInterval();
        int lookAhead = this.lookAheadInterval + this.timeDriftCorrection;
        int lookBehind = -this.lookBehindInterval + this.timeDriftCorrection;
        if (train) {
            lookAhead = 60;
            lookBehind = 60;
        }
        for (int i = lookAhead; i >= lookBehind; --i) {
            int candidate = this.generate(this.secret, currentInterval + (long)i);
            if ((long)candidate != code) continue;
            this.timeDriftCorrection = i;
            return true;
        }
        return false;
    }

    @Override
    public boolean verify(String otp) {
        return this._verify(otp, false);
    }

    public boolean train(String otp) {
        return this._verify(otp, true);
    }

    public int getLookAheadInterval() {
        return this.lookAheadInterval;
    }

    public int getLookBehindInterval() {
        return this.lookBehindInterval;
    }

    public int getTimeDriftCorrection() {
        return this.timeDriftCorrection;
    }
}

