/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.sqlite;

import dev.tuxjsql.basic.sql.select.BasicJoinStatement;
import dev.tuxjsql.basic.sql.select.BasicSelectStatement;
import dev.tuxjsql.basic.sql.where.BasicWhereStatement;
import dev.tuxjsql.basic.utils.BasicUtils;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.response.DBAction;
import dev.tuxjsql.core.response.DBSelect;
import dev.tuxjsql.core.sql.SQLColumn;
import dev.tuxjsql.sqlite.Queries;
import dev.tuxjsql.sqlite.SQLiteJoinTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLiteSelectStatement
extends BasicSelectStatement {
    public SQLiteSelectStatement(TuxJSQL tuxJSQL) {
        super(tuxJSQL);
    }

    public DBAction<DBSelect> execute() {
        return new DBAction(this::select, this.tuxJSQL);
    }

    private DBSelect select() {
        DBSelect dbSelect = null;
        StringBuilder columnBuilder = new StringBuilder();
        int i = 0;
        if (this.columns.isEmpty()) {
            columnBuilder.append("*");
        } else {
            for (SQLColumn column : this.columns) {
                if (i != 0) {
                    columnBuilder.append(",");
                }
                columnBuilder.append(column.getTable().getName()).append(".").append(column.getName());
                ++i;
            }
        }
        String select = String.format(Queries.SELECT.getString(), columnBuilder.toString(), this.table.getName());
        Object[] values = new Object[]{};
        BasicJoinStatement joinStatement = (BasicJoinStatement)this.join;
        if (joinStatement.getJoinType() != null) {
            select = select + " " + String.format(Queries.JOIN.getString(), SQLiteJoinTypes.getType(joinStatement.getJoinType()).getKey(), joinStatement.getTableTwo().getTable().getName(), this.table.getName(), joinStatement.getTableOneColumn(), joinStatement.getTableTwo().getName());
        }
        ((BasicWhereStatement)this.whereStatement).setTable(this.table);
        if (this.whereStatement.getValues().length != 0) {
            select = String.format("%s WHERE %s", select, this.whereStatement.getQuery());
            values = this.whereStatement.getValues();
        }
        TuxJSQL.getLogger().debug(select);
        try (Connection connection = this.tuxJSQL.getConnection();
             PreparedStatement statement = connection.prepareStatement(select);){
            i = 1;
            for (Object o : values) {
                statement.setObject(i++, o);
            }
            ResultSet set = statement.executeQuery();
            dbSelect = BasicUtils.resultSetToDBSelect((ResultSet)set);
        }
        catch (SQLException e) {
            TuxJSQL.getLogger().error("Unable to select", (Throwable)e);
        }
        return dbSelect;
    }
}

