/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.sqlite;

import dev.tuxjsql.basic.response.BasicDBUpdate;
import dev.tuxjsql.basic.sql.BasicUpdateStatement;
import dev.tuxjsql.basic.sql.where.BasicWhereStatement;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.response.DBAction;
import dev.tuxjsql.core.response.DBUpdate;
import dev.tuxjsql.sqlite.Queries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

public class SQLiteUpdateStatement
extends BasicUpdateStatement {
    public SQLiteUpdateStatement(TuxJSQL tuxJSQL) {
        super(tuxJSQL);
    }

    public DBAction<DBUpdate> execute() {
        return new DBAction(this::dbUpdate, this.tuxJSQL);
    }

    private DBUpdate dbUpdate() {
        ((BasicWhereStatement)this.whereStatement).setTable(this.sqlTable);
        BasicDBUpdate dbUpdate = null;
        ArrayList columns = new ArrayList();
        ArrayList<Object> values = new ArrayList<Object>();
        this.values.forEach((s, o) -> {
            columns.add(s);
            values.add(o);
        });
        StringBuilder columnToUpdate = new StringBuilder();
        for (String column : columns) {
            if (!columnToUpdate.toString().isEmpty()) {
                columnToUpdate.append(",");
            }
            columnToUpdate.append("`").append(column).append("`").append("=?");
        }
        String query = String.format(Queries.UPDATE.getString(), this.sqlTable.getName(), columnToUpdate);
        if (this.whereStatement.getValues().length != 0) {
            query = query + " " + String.format(Queries.WHERE.getString(), this.whereStatement.getQuery());
            values.addAll(Arrays.asList(this.whereStatement.getValues()));
        }
        if (TuxJSQL.getLogger().isDebugEnabled()) {
            TuxJSQL.getLogger().debug(query);
        }
        try (Connection connection = this.tuxJSQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int i = 1;
            for (Object e : values) {
                preparedStatement.setObject(i++, e);
            }
            dbUpdate = new BasicDBUpdate(this.sqlTable, preparedStatement.executeUpdate(), true);
        }
        catch (SQLException e) {
            TuxJSQL.getLogger().error("Unable to update rows", (Throwable)e);
            return new BasicDBUpdate(this.sqlTable, 0, false);
        }
        return dbUpdate;
    }
}

