/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.sqlite;

import dev.tuxjsql.basic.response.BasicDBSelect;
import dev.tuxjsql.basic.sql.select.BasicJoinStatement;
import dev.tuxjsql.basic.sql.select.BasicSelectStatement;
import dev.tuxjsql.basic.sql.where.BasicWhereStatement;
import dev.tuxjsql.basic.utils.BasicUtils;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.response.DBAction;
import dev.tuxjsql.core.response.DBSelect;
import dev.tuxjsql.core.sql.SQLColumn;
import dev.tuxjsql.sqlite.Queries;
import dev.tuxjsql.sqlite.SQLiteJoinTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLiteSelectStatement
extends BasicSelectStatement {
    public SQLiteSelectStatement(TuxJSQL tuxJSQL) {
        super(tuxJSQL);
    }

    public DBAction<DBSelect> execute() {
        return new DBAction(this::select, this.tuxJSQL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DBSelect select() {
        BasicDBSelect dbSelect = null;
        StringBuilder columnBuilder = new StringBuilder();
        int i = 0;
        if (this.columns.isEmpty()) {
            columnBuilder.append("*");
        } else {
            for (SQLColumn column : this.columns) {
                if (i != 0) {
                    columnBuilder.append(",");
                }
                columnBuilder.append(column.getTable().getName()).append(".").append(column.getName());
                ++i;
            }
        }
        String select = String.format(Queries.SELECT.getString(), columnBuilder.toString(), this.table.getName());
        Object[] values = new Object[]{};
        BasicJoinStatement joinStatement = (BasicJoinStatement)this.join;
        if (joinStatement.getJoinType() != null) {
            select = select + " " + String.format(Queries.JOIN.getString(), SQLiteJoinTypes.getType(joinStatement.getJoinType()).getKey(), joinStatement.getTableTwo().getTable().getName(), this.table.getName(), joinStatement.getTableOneColumn(), joinStatement.getTableTwo().getName());
        }
        ((BasicWhereStatement)this.whereStatement).setTable(this.table);
        if (this.whereStatement.getValues().length != 0) {
            select = String.format("%s WHERE %s", select, this.whereStatement.getQuery());
            values = this.whereStatement.getValues();
        }
        TuxJSQL.getLogger().debug(select);
        try (Connection connection = this.tuxJSQL.getConnection();
             PreparedStatement statement = connection.prepareStatement(select);){
            i = 1;
            for (Object o : values) {
                statement.setObject(i++, o);
            }
            try {
                Throwable throwable;
                ResultSet set;
                block66: {
                    BasicDBSelect basicDBSelect;
                    block67: {
                        set = statement.executeQuery();
                        throwable = null;
                        if (set != null && !set.isClosed()) break block66;
                        basicDBSelect = new BasicDBSelect(false, this.table);
                        if (set == null) return basicDBSelect;
                        if (throwable == null) break block67;
                        try {
                            set.close();
                            return basicDBSelect;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return basicDBSelect;
                        }
                    }
                    set.close();
                    return basicDBSelect;
                }
                try {
                    dbSelect = new BasicDBSelect(BasicUtils.resultSetToDBSelect((ResultSet)set, (TuxJSQL)this.tuxJSQL), true, this.table);
                    return dbSelect;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (set != null) {
                        if (throwable != null) {
                            try {
                                set.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            set.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                TuxJSQL.getLogger().error("Unable to select", (Throwable)e);
                BasicDBSelect basicDBSelect = new BasicDBSelect(false, this.table);
                if (statement != null) {
                    if (var10_13 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var10_13.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
                if (connection == null) return basicDBSelect;
                if (var8_9 != null) {
                    try {
                        connection.close();
                        return basicDBSelect;
                    }
                    catch (Throwable throwable) {
                        var8_9.addSuppressed(throwable);
                        return basicDBSelect;
                    }
                }
                connection.close();
                return basicDBSelect;
            }
        }
        catch (SQLException e) {
            TuxJSQL.getLogger().error("Unable to select", (Throwable)e);
            return new BasicDBSelect(false, this.table);
        }
    }
}

