/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.mysql;

import dev.tuxjsql.basic.response.BasicDBDelete;
import dev.tuxjsql.basic.sql.BasicDeleteStatement;
import dev.tuxjsql.basic.sql.where.BasicWhereStatement;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.response.DBAction;
import dev.tuxjsql.core.response.DBDelete;
import dev.tuxjsql.mysql.Queries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MysqlDeleteStatement
extends BasicDeleteStatement {
    public MysqlDeleteStatement(TuxJSQL tuxJSQL) {
        super(tuxJSQL);
    }

    public DBAction<DBDelete> execute() {
        return new DBAction(this::dbDelete, this.tuxJSQL);
    }

    private DBDelete dbDelete() {
        ((BasicWhereStatement)this.whereStatement).setTable(this.table);
        BasicDBDelete delete = null;
        String sql = String.format(Queries.DELETE.getString(), this.table.getName());
        if (this.whereStatement.getValues().length != 0) {
            sql = sql + " " + String.format(Queries.WHERE.getString(), this.whereStatement.getQuery());
        }
        TuxJSQL.getLogger().debug(sql);
        try (Connection connection = this.tuxJSQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int i = 1;
            for (Object object : this.whereStatement.getValues()) {
                preparedStatement.setObject(i++, object);
            }
            delete = new BasicDBDelete(this.table, preparedStatement.executeUpdate(), true);
        }
        catch (SQLException e) {
            TuxJSQL.getLogger().error("Unable to execute delete query", (Throwable)e);
            return new BasicDBDelete(this.table, 0, false);
        }
        return delete;
    }
}

