/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.mysql;

import dev.tuxjsql.basic.builders.BasicSQLBuilder;
import dev.tuxjsql.basic.sql.BasicDataTypes;
import dev.tuxjsql.basic.sql.select.BasicJoinStatement;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.builders.ColumnBuilder;
import dev.tuxjsql.core.builders.TableBuilder;
import dev.tuxjsql.core.connection.ConnectionProvider;
import dev.tuxjsql.core.connection.ConnectionSettings;
import dev.tuxjsql.core.sql.DeleteStatement;
import dev.tuxjsql.core.sql.InsertStatement;
import dev.tuxjsql.core.sql.SQLDataType;
import dev.tuxjsql.core.sql.UpdateStatement;
import dev.tuxjsql.core.sql.select.JoinStatement;
import dev.tuxjsql.core.sql.select.SelectStatement;
import dev.tuxjsql.core.sql.where.SubWhereStatement;
import dev.tuxjsql.core.sql.where.WhereStatement;
import dev.tuxjsql.mysql.MysqlColumnBuilder;
import dev.tuxjsql.mysql.MysqlDataTypes;
import dev.tuxjsql.mysql.MysqlDeleteStatement;
import dev.tuxjsql.mysql.MysqlInsertStatement;
import dev.tuxjsql.mysql.MysqlSelectStatement;
import dev.tuxjsql.mysql.MysqlSubWhereStatement;
import dev.tuxjsql.mysql.MysqlTableBuilder;
import dev.tuxjsql.mysql.MysqlUpdateStatement;
import dev.tuxjsql.mysql.MysqlWhereStatement;
import java.util.Properties;

public final class MysqlBuilder
extends BasicSQLBuilder {
    public static final String URL = "jdbc:mysql://%1$s/%2$s";
    public static final String JDBC_CLASS = "com.mysql.cj.jdbc.Driver";

    public TableBuilder createTable() {
        return new MysqlTableBuilder(this.tuxJSQL);
    }

    public ColumnBuilder createColumn() {
        return new MysqlColumnBuilder(this.tuxJSQL);
    }

    public WhereStatement createWhere() {
        return new MysqlWhereStatement(this.tuxJSQL);
    }

    public SubWhereStatement createSubWhereStatement() {
        return new MysqlSubWhereStatement(this.tuxJSQL);
    }

    public <T> WhereStatement<T> createWhere(T t) {
        return new MysqlWhereStatement<T>(t, this.tuxJSQL);
    }

    public <T> SubWhereStatement<T> createSubWhereStatement(T t) {
        return new MysqlSubWhereStatement<T>(t, this.tuxJSQL);
    }

    public SelectStatement createSelectStatement() {
        return new MysqlSelectStatement(this.tuxJSQL);
    }

    public JoinStatement createJoinStatement(SelectStatement basicSelectStatement) {
        return new BasicJoinStatement(basicSelectStatement);
    }

    public UpdateStatement createUpdateStatement() {
        return new MysqlUpdateStatement(this.tuxJSQL);
    }

    public DeleteStatement createDeleteStatement() {
        return new MysqlDeleteStatement(this.tuxJSQL);
    }

    public String name() {
        return "Mysql";
    }

    public String jdbcClass() {
        return JDBC_CLASS;
    }

    public SQLDataType convertDataType(BasicDataTypes dataType) {
        for (MysqlDataTypes type : MysqlDataTypes.values()) {
            if (type.getTypes() != dataType) continue;
            return type;
        }
        return null;
    }

    public InsertStatement createInsertStatement() {
        return new MysqlInsertStatement(this.tuxJSQL);
    }

    public void configureConnectionProvider(ConnectionProvider provider, Properties userProperties) throws Exception {
        String url = String.format(URL, userProperties.getProperty("db.host"), userProperties.getProperty("db.db"));
        if (userProperties.getProperty("url.other.options") != null) {
            url = url + "?" + userProperties.getProperty("url.other.options");
        }
        if (TuxJSQL.getLogger().isDebugEnabled()) {
            TuxJSQL.getLogger().debug(String.format("URL:%s", url));
        }
        provider.setup(new ConnectionSettings(this.jdbcClass(), url), userProperties);
    }

    public <T> ColumnBuilder<T> createColumn(T t) {
        return new MysqlColumnBuilder<T>(this.tuxJSQL, t);
    }
}

