/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.mysql;

import dev.tuxjsql.basic.sql.BasicSQLColumn;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.sql.SQLColumn;
import dev.tuxjsql.core.sql.SQLDataType;
import dev.tuxjsql.core.sql.SQLTable;
import dev.tuxjsql.mysql.Queries;
import java.util.List;

public class MysqlColumn
extends BasicSQLColumn {
    private static final String AUTOINCREMENT = " AUTO_INCREMENT";
    private static final String PRIMARY_KEY = " PRIMARY KEY";

    public MysqlColumn(String name, Object defaultValue, List<String> dataTypeRules, boolean notNull, boolean unique, boolean autoIncrement, boolean primaryKey, SQLColumn foreignKey, SQLTable table, SQLDataType type, TuxJSQL tuxJsql) {
        super(name, defaultValue, dataTypeRules, notNull, unique, autoIncrement, primaryKey, foreignKey, table, type, tuxJsql);
    }

    public String build() {
        if (this.defaultValue != null && this.getDataType().key().equals("TEXT")) {
            TuxJSQL.getLogger().warn("Unable to use DEFAULT with TEXT on MySQL");
            this.defaultValue = null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("`").append(this.name).append("`");
        builder.append(" ").append(this.buildDataType());
        builder.append(this.primaryKey() ? PRIMARY_KEY : "");
        builder.append(this.autoIncrement() ? AUTOINCREMENT : "");
        if (!this.autoIncrement()) {
            builder.append(this.notNull() ? " NOT NULL" : "");
            builder.append(this.unique() ? " UNIQUE" : "");
        }
        if (this.defaultValue != null) {
            builder.append(" DEFAULT ");
            builder.append("'").append(this.defaultValue).append("'");
        }
        return builder.toString();
    }

    public String foreignBuild() {
        return String.format(Queries.FOREIGN_VALUE.getString(), this.getName(), this.foreignKey().getTable().getName(), this.foreignKey().getName());
    }
}

