/*
 * Decompiled with CFR 0.152.
 */
package org.scalactic;

import org.scalactic.Equality;
import org.scalactic.Equivalence;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public interface TolerantNumerics {
    default public Equality<Object> tolerantDoubleEquality(double tolerance) {
        if (tolerance <= 0.0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToDouble((double)tolerance)).toString() + " passed to tolerantDoubleEquality was zero or negative. Must be a positive non-zero number.");
        }
        return new Equality(tolerance){
            private final double tolerance$1;
            {
                this.tolerance$1 = tolerance$8;
            }

            public boolean areEqual(double a, Object b) {
                double bDouble;
                Object object = b;
                return object instanceof Double ? a <= (bDouble = BoxesRunTime.unboxToDouble((Object)object)) + this.tolerance$1 && a >= bDouble - this.tolerance$1 : false;
            }

            public String toString() {
                return "TolerantDoubleEquality(" + this.tolerance$1 + ")";
            }
        };
    }

    default public Equality<Object> tolerantFloatEquality(float tolerance) {
        if (tolerance <= 0.0f) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToFloat((float)tolerance)).toString() + " passed to tolerantFloatEquality was zero or negative. Must be a positive non-zero number.");
        }
        return new Equality(tolerance){
            private final float tolerance$1;
            {
                this.tolerance$1 = tolerance$9;
            }

            public boolean areEqual(float a, Object b) {
                float bFloat;
                Object object = b;
                return object instanceof Float ? a <= (bFloat = BoxesRunTime.unboxToFloat((Object)object)) + this.tolerance$1 && a >= bFloat - this.tolerance$1 : false;
            }

            public String toString() {
                return "TolerantFloatEquality(" + this.tolerance$1 + ")";
            }
        };
    }

    default public Equality<Object> tolerantLongEquality(long tolerance) {
        if (tolerance <= 0L) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToLong((long)tolerance)).toString() + " passed to tolerantLongEquality was zero or negative. Must be a positive non-zero number.");
        }
        return new Equality(tolerance){
            private final long tolerance$1;
            {
                this.tolerance$1 = tolerance$10;
            }

            public boolean areEqual(long a, Object b) {
                long bLong;
                Object object = b;
                return object instanceof Long ? a <= (bLong = BoxesRunTime.unboxToLong((Object)object)) + this.tolerance$1 && a >= bLong - this.tolerance$1 : false;
            }

            public String toString() {
                return "TolerantLongEquality(" + this.tolerance$1 + ")";
            }
        };
    }

    default public Equality<Object> tolerantIntEquality(int tolerance) {
        if (tolerance <= 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger((int)tolerance)).toString() + " passed to tolerantIntEquality was zero or negative. Must be a positive non-zero number.");
        }
        return new Equality(tolerance){
            private final int tolerance$1;
            {
                this.tolerance$1 = tolerance$11;
            }

            public boolean areEqual(int a, Object b) {
                int bInt;
                Object object = b;
                return object instanceof Integer ? a <= (bInt = BoxesRunTime.unboxToInt((Object)object)) + this.tolerance$1 && a >= bInt - this.tolerance$1 : false;
            }

            public String toString() {
                return "TolerantIntEquality(" + this.tolerance$1 + ")";
            }
        };
    }

    default public Equality<Object> tolerantShortEquality(short tolerance) {
        if (tolerance <= 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToShort((short)tolerance)).toString() + " passed to tolerantShortEquality was zero or negative. Must be a positive non-zero number.");
        }
        return new Equality(tolerance){
            private final short tolerance$1;
            {
                this.tolerance$1 = tolerance$12;
            }

            public boolean areEqual(short a, Object b) {
                short bShort;
                Object object = b;
                return object instanceof Short ? a <= (bShort = BoxesRunTime.unboxToShort((Object)object)) + this.tolerance$1 && a >= bShort - this.tolerance$1 : false;
            }

            public String toString() {
                return "TolerantShortEquality(" + this.tolerance$1 + ")";
            }
        };
    }

    default public Equality<Object> tolerantByteEquality(byte tolerance) {
        if (tolerance <= 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToByte((byte)tolerance)).toString() + " passed to tolerantByteEquality was zero or negative. Must be a positive non-zero number.");
        }
        return new Equality(tolerance){
            private final byte tolerance$1;
            {
                this.tolerance$1 = tolerance$13;
            }

            public boolean areEqual(byte a, Object b) {
                byte bByte;
                Object object = b;
                return object instanceof Byte ? a <= (bByte = BoxesRunTime.unboxToByte((Object)object)) + this.tolerance$1 && a >= bByte - this.tolerance$1 : false;
            }

            public String toString() {
                return "TolerantByteEquality(" + this.tolerance$1 + ")";
            }
        };
    }

    default public <N> Equivalence<N> tolerantEquivalence(N tolerance, Numeric<N> evidence$1) {
        Numeric<N> numeric = evidence$1;
        if (numeric.lt(tolerance, numeric.zero())) {
            throw new IllegalArgumentException(tolerance.toString() + " passed to tolerantEquivalence was zero or negative. Must be a positive non-zero number.");
        }
        return new Equivalence(tolerance, numeric){
            private final Object tolerance$1;
            private final Numeric numeric$1;
            {
                this.tolerance$1 = tolerance$14;
                this.numeric$1 = numeric$2;
            }

            public boolean areEquivalent(Object a, Object b) {
                Object bPlusTolerance = this.numeric$1.plus(b, this.tolerance$1);
                Object bMinusTolerance = this.numeric$1.minus(b, this.tolerance$1);
                return this.numeric$1.lteq(a, bPlusTolerance) && this.numeric$1.gteq(a, bMinusTolerance);
            }

            public String toString() {
                return "TolerantEquivalence(" + this.tolerance$1 + ")";
            }
        };
    }
}

