package antd


/**
 * https://www.npmjs.com/package/rc-select#option-props
 */
@OptIn(ExperimentalJsExport::class)
@JsExport
data class Option(

    val value: String,

    val label: String = value,

    /**
     * if React want you to set key, then key is same as value, you can omit value
     */
    val key: dynamic = null,  // string | number

    val disabled: Boolean = false

)
