/*
 * Decompiled with CFR 0.152.
 */
package dev.tobee.telegram.client;

import dev.tobee.telegram.model.media.FileEntity;
import dev.tobee.telegram.request.Request;
import dev.tobee.telegram.util.DefaultJsonMapper;
import dev.tobee.telegram.util.DefaultObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record TbdAsyncClient(boolean isDebugEnabled, String host, String token) {
    private static final Logger logger = LoggerFactory.getLogger(TbdAsyncClient.class);
    private static final DefaultJsonMapper mapper = new DefaultJsonMapper();
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(5L);
    private static final String DEFAULT_MIME_TYPE = "application/json";

    public <T> CompletableFuture<T> getRequest(Request<T> request) {
        StringBuilder urlBuilder = new StringBuilder(this.host).append("/").append(this.token).append("/").append(request.getMethod());
        if (!request.getQueryParams().isEmpty()) {
            urlBuilder.append("?");
            request.getQueryParams().forEach((key, value) -> urlBuilder.append("&").append((String)key).append("=").append((String)value));
        }
        URI uri = URI.create(urlBuilder.toString());
        logger.debug("Request to {}", (Object)uri);
        return ((CompletableFuture)((CompletableFuture)HttpClient.newHttpClient().sendAsync(HttpRequest.newBuilder().header("Content-Type", DEFAULT_MIME_TYPE).headers("Accept", DEFAULT_MIME_TYPE).timeout(DEFAULT_TIMEOUT).uri(uri).build(), HttpResponse.BodyHandlers.ofString()).thenApplyAsync(this::logResponse)).thenApply(HttpResponse::body)).thenApply(body -> mapper.parseResponse((String)body, request.getResponseType()));
    }

    public <T> T getRequestSync(Request<T> request) throws IOException, InterruptedException {
        URI uri = URI.create(this.host + "/" + this.token + "/" + request.getMethod());
        logger.debug("Request to {}", (Object)uri);
        HttpRequest requestObj = HttpRequest.newBuilder().header("Content-Type", DEFAULT_MIME_TYPE).headers("Accept", DEFAULT_MIME_TYPE).timeout(DEFAULT_TIMEOUT).uri(uri).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(requestObj, HttpResponse.BodyHandlers.ofString());
        this.logResponse(response);
        return mapper.parseResponse(response.body(), request.getResponseType());
    }

    public <T> CompletableFuture<T> postRequest(Request<T> request) {
        String boundary = UUID.randomUUID().toString();
        URI uri = URI.create(this.host + "/" + this.token + "/" + request.getMethod());
        return ((CompletableFuture)((CompletableFuture)HttpClient.newHttpClient().sendAsync(HttpRequest.newBuilder().header("Content-Type", "multipart/form-data; charset=utf-8; boundary=" + boundary).uri(uri).timeout(DEFAULT_TIMEOUT).POST(this.prepareMultipartData(request.getBody().orElseThrow(), boundary)).build(), HttpResponse.BodyHandlers.ofString()).thenApplyAsync(this::logResponse)).thenApply(HttpResponse::body)).thenApply(body -> mapper.parseResponse((String)body, request.getResponseType()));
    }

    private HttpRequest.BodyPublisher prepareMultipartData(Map<Object, Object> data, String boundary) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        byte[] separator = ("--" + boundary + "\r\nContent-Disposition: form-data; name=").getBytes(StandardCharsets.UTF_8);
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            if (entry.getValue() == null) continue;
            byteArrays.add(separator);
            if (entry.getValue() instanceof LinkedHashMap && ((LinkedHashMap)entry.getValue()).containsKey("file_name")) {
                FileEntity file = (FileEntity)DefaultObjectMapper.getMapper().convertValue(entry.getValue(), FileEntity.class);
                byteArrays.add(("\"" + entry.getKey() + "\"; filename=\"" + file.getFileName() + "\"\r\nContent-Type: " + file.getMimeType() + "\r\n\r\n").getBytes(StandardCharsets.UTF_8));
                byteArrays.add(file.getContent());
                byteArrays.add("\r\n".getBytes(StandardCharsets.UTF_8));
                continue;
            }
            byteArrays.add(("\"" + entry.getKey() + "\"\r\n\r\n" + entry.getValue() + "\r\n").getBytes(StandardCharsets.UTF_8));
        }
        byteArrays.add(("--" + boundary + "--").getBytes(StandardCharsets.UTF_8));
        if (this.isDebugEnabled) {
            this.printDebugMultipartData(byteArrays);
        }
        return HttpRequest.BodyPublishers.ofByteArrays(byteArrays);
    }

    private void printDebugMultipartData(ArrayList<byte[]> byteArrays) {
        byte[] all = new byte[byteArrays.stream().mapToInt(a -> ((byte[])a).length).sum()];
        int pos = 0;
        for (byte[] bin : byteArrays) {
            int length = bin.length;
            System.arraycopy(bin, 0, all, pos, length);
            pos += length;
        }
        String data = new String(all);
        logger.debug("Multipart request data \n{}", (Object)data);
    }

    private HttpResponse<String> logResponse(HttpResponse<String> response) {
        if (logger.isDebugEnabled() && Objects.nonNull(response.body())) {
            logger.debug("Response {}", (Object)response.body());
        }
        return response;
    }
}

