/*
 * Decompiled with CFR 0.152.
 */
package dev.tobee.telegram;

import dev.tobee.telegram.TelegramBot;
import dev.tobee.telegram.client.TbdAsyncClient;
import dev.tobee.telegram.model.message.Update;
import dev.tobee.telegram.model.message.UpdateTypes;
import dev.tobee.telegram.request.body.GetUpdateBody;
import dev.tobee.telegram.request.chat.GetUpdates;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SubmissionPublisher;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongPollingTelegramBot
implements TelegramBot {
    private static final Logger logger = LoggerFactory.getLogger(LongPollingTelegramBot.class);
    private final ScheduledExecutorService executorService;
    private final OptionalInt initialDelay = OptionalInt.empty();
    private final OptionalInt period = OptionalInt.empty();
    private final TbdAsyncClient tbdTGReactorClient;
    private final SubmissionPublisher<Update> publisher = new SubmissionPublisher();
    boolean status = true;

    public LongPollingTelegramBot(TbdAsyncClient tbdTGReactorClient, List<Flow.Subscriber<Update>> subscribers) {
        this.tbdTGReactorClient = tbdTGReactorClient;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        subscribers.forEach(this.publisher::subscribe);
    }

    public LongPollingTelegramBot(String host, String token, ScheduledExecutorService executorService, Flow.Subscriber<Update> subscriber) {
        this.tbdTGReactorClient = new TbdAsyncClient(true, host, token);
        this.executorService = executorService;
        this.publisher.subscribe(subscriber);
    }

    public LongPollingTelegramBot(String host, String token, Flow.Subscriber<Update> subscriber) {
        this.tbdTGReactorClient = new TbdAsyncClient(true, host, token);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.publisher.subscribe(subscriber);
    }

    @Override
    public void subscribeToUpdate() {
        AtomicLong lastUpdate = new AtomicLong();
        this.executorService.scheduleAtFixedRate(() -> {
            try {
                GetUpdates request = lastUpdate.get() > 0L ? new GetUpdates(Optional.of(new GetUpdateBody(OptionalLong.of(lastUpdate.get()), OptionalInt.empty(), OptionalInt.empty(), List.of(UpdateTypes.MESSAGE, UpdateTypes.CALLBACK_QUERY, UpdateTypes.CHANNEL_POST)))) : new GetUpdates(Optional.empty());
                Optional<List<Update>> updates = this.tbdTGReactorClient.getRequestSync(request).result();
                updates.stream().flatMap(Collection::stream).forEach(this.publisher::submit);
                Optional<Update> lastUpdateObj = this.getLastUpdateFromResponse(updates);
                this.handleLastUpdateId(lastUpdateObj, lastUpdate);
            }
            catch (Exception e) {
                logger.error("Error on receive update", (Throwable)e);
            }
        }, this.initialDelay.orElse(1), this.period.orElse(1), TimeUnit.SECONDS);
    }

    private Optional<Update> getLastUpdateFromResponse(Optional<List<Update>> lastUpdate) {
        Optional<Update> lastUpdateObj = Optional.empty();
        if (lastUpdate.isPresent() && !lastUpdate.orElseThrow().isEmpty()) {
            lastUpdateObj = Optional.ofNullable(lastUpdate.get().get(lastUpdate.get().size() - 1));
        }
        return lastUpdateObj;
    }

    private void handleLastUpdateId(Optional<Update> update, AtomicLong lastUpdate) {
        if (update.isPresent()) {
            lastUpdate.set(update.get().updateId().orElse(0L) + 1L);
        }
    }

    @Override
    public TbdAsyncClient getClient() {
        return this.tbdTGReactorClient;
    }
}

