/*
 * Decompiled with CFR 0.152.
 */
package dev.tobee.telegram.request;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.tobee.telegram.model.ResponseWrapper;
import dev.tobee.telegram.request.Request;
import dev.tobee.telegram.request.body.SetMyCommandsBody;
import dev.tobee.telegram.util.DefaultJsonMapper;
import dev.tobee.telegram.util.DefaultObjectMapper;
import java.util.Map;
import java.util.Optional;

public class SetMyCommands
implements Request<ResponseWrapper<Boolean>> {
    private static final String METHOD = "setMyCommands";
    private static final TypeReference<ResponseWrapper<Boolean>> reference = new TypeReference<ResponseWrapper<Boolean>>(){};
    private final DefaultObjectMapper mapper = new DefaultObjectMapper();
    private final DefaultJsonMapper jsonMapper = new DefaultJsonMapper();
    private final SetMyCommandsBody body;

    public SetMyCommands(SetMyCommandsBody body) {
        this.body = body;
    }

    @Override
    public String getMethod() {
        return METHOD;
    }

    @Override
    public TypeReference<ResponseWrapper<Boolean>> getResponseType() {
        return reference;
    }

    @Override
    public Optional<Map<Object, Object>> getBody() {
        String scopeFieldName;
        String commandsFieldName;
        Map<Object, Object> bodyMap = this.mapper.convertToMap(this.body);
        if (bodyMap.containsKey(commandsFieldName = "commands")) {
            bodyMap.put(commandsFieldName, this.jsonMapper.convertToString(this.body.commands()));
        }
        if (bodyMap.containsKey(scopeFieldName = "scope")) {
            bodyMap.put(scopeFieldName, this.jsonMapper.convertToString(this.body.scope()));
        }
        return Optional.of(bodyMap);
    }
}

