/*
 * Decompiled with CFR 0.152.
 */
package dev.tobee.telegram.request;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.tobee.telegram.model.Message;
import dev.tobee.telegram.model.ResponseWrapper;
import dev.tobee.telegram.request.Request;
import dev.tobee.telegram.request.body.SendVideoNoteBody;
import dev.tobee.telegram.util.DefaultJsonMapper;
import dev.tobee.telegram.util.DefaultObjectMapper;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;

public class SendVideoNote
implements Request<ResponseWrapper<Message>> {
    private static final String METHOD = "sendVideoNote";
    private final DefaultObjectMapper mapper = new DefaultObjectMapper();
    private final DefaultJsonMapper jsonMapper = new DefaultJsonMapper();
    private static final TypeReference<ResponseWrapper<Message>> reference = new TypeReference<ResponseWrapper<Message>>(){};
    private final SendVideoNoteBody body;

    public SendVideoNote(SendVideoNoteBody body) {
        this.body = body;
    }

    @Override
    public String getMethod() {
        return METHOD;
    }

    @Override
    public TypeReference<ResponseWrapper<Message>> getResponseType() {
        return reference;
    }

    @Override
    public Optional<Map<Object, Object>> getBody() {
        String replyMarkupFieldName;
        String photoFieldName;
        Map<Object, Object> bodyMap = this.mapper.convertToMap(this.body);
        if (bodyMap.containsKey(photoFieldName = "video_note") && bodyMap.get(photoFieldName) instanceof String) {
            bodyMap.put(photoFieldName, Paths.get(URI.create(String.valueOf(bodyMap.get(photoFieldName)))));
        }
        if (bodyMap.containsKey(replyMarkupFieldName = "reply_markup")) {
            bodyMap.put(replyMarkupFieldName, this.jsonMapper.convertToString(this.body.replyMarkup()));
        }
        return Optional.of(bodyMap);
    }
}

