/*
 * Decompiled with CFR 0.152.
 */
package dev.tiebe.magisterapi.utils;

import com.soywiz.krypto.SHA256;
import com.soywiz.krypto.SecureRandom;
import dev.tiebe.magisterapi.response.TokenResponse;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.matthewnelson.component.base64.Base64;
import io.matthewnelson.component.base64.Base64Kt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\n\u00a8\u0006\r"}, d2={"Ldev/tiebe/magisterapi/utils/LoginUtility;", "", "()V", "checkExpired", "", "tokenResponse", "Ldev/tiebe/magisterapi/response/TokenResponse;", "expiresAt", "", "generateCodeChallenge", "", "codeVerifier", "generateCodeVerifier", "magisterapi"})
@SourceDebugExtension(value={"SMAP\nLoginUtility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginUtility.kt\ndev/tiebe/magisterapi/utils/LoginUtility\n+ 2 Base64.kt\nio/matthewnelson/component/base64/Base64Kt\n+ 3 Strings.kt\nio/ktor/utils/io/core/StringsKt\n*L\n1#1,32:1\n177#2,12:33\n177#2,12:49\n7#3,4:45\n*S KotlinDebug\n*F\n+ 1 LoginUtility.kt\ndev/tiebe/magisterapi/utils/LoginUtility\n*L\n15#1:33,12\n22#1:49,12\n20#1:45,4\n*E\n"})
public final class LoginUtility {
    @NotNull
    public static final LoginUtility INSTANCE = new LoginUtility();

    private LoginUtility() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateCodeVerifier() {
        void $this$encodeBase64$iv;
        byte[] codeVerifier = new byte[32];
        SecureRandom.INSTANCE.nextBytes(codeVerifier);
        byte[] byArray = codeVerifier;
        Base64 base64$iv = (Base64)new Base64.UrlSafe(false);
        boolean $i$f$encodeBase64 = false;
        void $this$encodeBase64ToCharArray$iv$iv = $this$encodeBase64$iv;
        boolean $i$f$encodeBase64ToCharArray = false;
        byte[] bytes$iv$iv = Base64Kt.encodeBase64ToByteArray((byte[])$this$encodeBase64ToCharArray$iv$iv, (Base64)base64$iv);
        boolean bl = false;
        char[] chars$iv$iv = new char[bytes$iv$iv.length];
        int n = bytes$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            int i$iv$iv = i;
            byte byte$iv$iv = bytes$iv$iv[i];
            chars$iv$iv[i$iv$iv] = (char)byte$iv$iv;
        }
        return ArraysKt.joinToString$default((char[])chars$iv$iv, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateCodeChallenge(@NotNull String codeVerifier) {
        void $this$encodeBase64$iv;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        Object $this$toByteArray_u24default$iv = codeVerifier;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
            byArray = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
        } else {
            CharsetEncoder charsetEncoder = charset$iv.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)((CharSequence)$this$toByteArray_u24default$iv), (int)0, (int)((String)$this$toByteArray_u24default$iv).length());
        }
        byte[] bytes = byArray;
        $this$toByteArray_u24default$iv = SHA256.Companion.digest(bytes).getBytes();
        Base64 base64$iv = (Base64)new Base64.UrlSafe(false);
        boolean $i$f$encodeBase64 = false;
        void $this$encodeBase64ToCharArray$iv$iv = $this$encodeBase64$iv;
        boolean $i$f$encodeBase64ToCharArray = false;
        byte[] bytes$iv$iv = Base64Kt.encodeBase64ToByteArray((byte[])$this$encodeBase64ToCharArray$iv$iv, (Base64)base64$iv);
        boolean bl = false;
        char[] chars$iv$iv = new char[bytes$iv$iv.length];
        int n = bytes$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            int i$iv$iv = i;
            byte byte$iv$iv = bytes$iv$iv[i];
            chars$iv$iv[i$iv$iv] = (char)byte$iv$iv;
        }
        return ArraysKt.joinToString$default((char[])chars$iv$iv, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    public final boolean checkExpired(long expiresAt) {
        return Clock.System.INSTANCE.now().getEpochSeconds() > expiresAt;
    }

    public final boolean checkExpired(@NotNull TokenResponse tokenResponse) {
        Intrinsics.checkNotNullParameter((Object)tokenResponse, (String)"tokenResponse");
        return this.checkExpired(tokenResponse.getExpiresAt());
    }
}

