/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.reflectcase.joor;

import dev.thecodewarrior.reflectcase.joor.CompileException;
import dev.thecodewarrior.reflectcase.joor.CompileOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class Compile {
    private static final ClassLoader rootClassLoader = MethodHandles.lookup().lookupClass().getClassLoader();
    private static final RuntimeClassLoader nullClassLoader = new RuntimeClassLoader(rootClassLoader, new HashMap<String, byte[]>());

    public static RuntimeClassLoader compile(Map<String, String> code, CompileOptions compileOptions) {
        if (code.isEmpty()) {
            return nullClassLoader;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try {
            ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
            ArrayList<CharSequenceJavaFileObject> files = new ArrayList<CharSequenceJavaFileObject>();
            for (Map.Entry<String, String> entry : code.entrySet()) {
                files.add(new CharSequenceJavaFileObject(entry.getKey(), entry.getValue()));
            }
            StringWriter out = new StringWriter();
            ArrayList<String> options = new ArrayList<String>(compileOptions.options);
            if (!options.contains("-classpath")) {
                StringBuilder classpath = new StringBuilder();
                String separator = System.getProperty("path.separator");
                String prop = System.getProperty("java.class.path");
                if (prop != null && !"".equals(prop)) {
                    classpath.append(prop);
                }
                if (rootClassLoader instanceof URLClassLoader) {
                    for (URL url : ((URLClassLoader)rootClassLoader).getURLs()) {
                        if (classpath.length() > 0) {
                            classpath.append(separator);
                        }
                        if (!"file".equals(url.getProtocol())) continue;
                        classpath.append(new File(url.toURI()));
                    }
                }
                options.addAll(Arrays.asList("-classpath", classpath.toString()));
            }
            JavaCompiler.CompilationTask task = compiler.getTask(out, fileManager, null, options, null, files);
            if (!compileOptions.processors.isEmpty()) {
                task.setProcessors(compileOptions.processors);
            }
            task.call();
            if (!out.toString().equals("")) {
                throw new CompileException("Compilation error:\n" + out);
            }
            return fileManager.createClassLoader(rootClassLoader);
        }
        catch (Exception e) {
            throw new CompileException("Error while compiling classes", e);
        }
    }

    public static final class RuntimeClassLoader
    extends ClassLoader {
        private final Map<String, byte[]> classes;
        public final Set<String> classNames;

        public RuntimeClassLoader(ClassLoader parent, Map<String, byte[]> classes) {
            super(parent);
            this.classes = classes;
            this.classNames = Collections.unmodifiableSet(classes.keySet());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] data = this.classes.get(name);
            if (data != null) {
                String pkgname;
                int i = name.lastIndexOf(46);
                if (i != -1 && this.getPackage(pkgname = name.substring(0, i)) == null) {
                    this.definePackage(pkgname, null, null, null, null, null, null, null);
                }
                return this.defineClass(name, data, 0, data.length);
            }
            throw new ClassNotFoundException(name);
        }
    }

    static final class ClassFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        private final Map<String, JavaFileObject> fileObjectMap = new HashMap<String, JavaFileObject>();
        private Map<String, byte[]> classes;

        ClassFileManager(StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
            JavaFileObject result = new JavaFileObject(className, kind);
            this.fileObjectMap.put(className, result);
            return result;
        }

        boolean isEmpty() {
            return this.fileObjectMap.isEmpty();
        }

        Map<String, byte[]> classes() {
            if (this.classes == null) {
                this.classes = new HashMap<String, byte[]>();
                for (Map.Entry<String, JavaFileObject> entry : this.fileObjectMap.entrySet()) {
                    this.classes.put(entry.getKey(), entry.getValue().getBytes());
                }
            }
            return this.classes;
        }

        RuntimeClassLoader createClassLoader(ClassLoader parent) {
            return new RuntimeClassLoader(parent, this.classes());
        }
    }

    protected static final class CharSequenceJavaFileObject
    extends SimpleJavaFileObject {
        final CharSequence content;

        public CharSequenceJavaFileObject(String className, CharSequence content) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }
    }

    static final class JavaFileObject
    extends SimpleJavaFileObject {
        final ByteArrayOutputStream os = new ByteArrayOutputStream();

        JavaFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/') + kind.extension), kind);
        }

        byte[] getBytes() {
            return this.os.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() {
            return this.os;
        }
    }
}

