/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.reflectcase.impl;

import dev.thecodewarrior.reflectcase.impl.TypeSetBuilderImpl;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0006\u0010\u0017\u001a\u00020\u0007J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0012\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eJ\u0012\u0010\u001f\u001a\u00020 2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eJ\u0012\u0010!\u001a\u00020\"2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eJ\t\u0010#\u001a\u00020\u0005H\u00d6\u0001J\t\u0010$\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006%"}, d2={"Ldev/thecodewarrior/reflectcase/impl/TypeDefinition;", "", "block", "Ldev/thecodewarrior/reflectcase/impl/TypeSetBuilderImpl;", "index", "", "name", "", "type", "(Ldev/thecodewarrior/reflectcase/impl/TypeSetBuilderImpl;ILjava/lang/String;Ljava/lang/String;)V", "getBlock", "()Ldev/thecodewarrior/reflectcase/impl/TypeSetBuilderImpl;", "fieldName", "getIndex", "()I", "getName", "()Ljava/lang/String;", "getType", "component1", "component2", "component3", "component4", "copy", "createClassText", "equals", "", "other", "getAnnotated", "Ljava/lang/reflect/AnnotatedType;", "rootClass", "Ljava/lang/Class;", "getField", "Ljava/lang/reflect/Field;", "getGeneric", "Ljava/lang/reflect/Type;", "hashCode", "toString", "reflectcase"})
public final class TypeDefinition {
    @NotNull
    private final TypeSetBuilderImpl block;
    private final int index;
    @NotNull
    private final String name;
    @NotNull
    private final String type;
    @NotNull
    private final String fieldName;

    public TypeDefinition(@NotNull TypeSetBuilderImpl block, int index, @NotNull String name, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.block = block;
        this.index = index;
        this.name = name;
        this.type = type;
        this.fieldName = Intrinsics.stringPlus((String)"type_", (Object)this.index);
    }

    @NotNull
    public final TypeSetBuilderImpl getBlock() {
        return this.block;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final AnnotatedType getAnnotated(@NotNull Class<?> rootClass) {
        Intrinsics.checkNotNullParameter(rootClass, (String)"rootClass");
        AnnotatedType annotatedType = this.getField(rootClass).getAnnotatedType();
        if (annotatedType == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.AnnotatedParameterizedType");
        }
        AnnotatedType annotatedType2 = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()[0];
        Intrinsics.checkNotNullExpressionValue((Object)annotatedType2, (String)"(getField(rootClass).annotatedType as AnnotatedParameterizedType).annotatedActualTypeArguments[0]");
        return annotatedType2;
    }

    @NotNull
    public final Type getGeneric(@NotNull Class<?> rootClass) {
        Intrinsics.checkNotNullParameter(rootClass, (String)"rootClass");
        Type type = this.getField(rootClass).getGenericType();
        if (type == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        }
        Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"(getField(rootClass).genericType as ParameterizedType).actualTypeArguments[0]");
        return type2;
    }

    @NotNull
    public final Field getField(@NotNull Class<?> rootClass) {
        Intrinsics.checkNotNullParameter(rootClass, (String)"rootClass");
        Class<?> blockClass = this.block.getClass(rootClass);
        Field field = blockClass.getDeclaredField(this.fieldName);
        if (field == null) {
            throw new IllegalStateException("Unable to find field " + this.fieldName + " in type block");
        }
        return field;
    }

    @NotNull
    public final String createClassText() {
        String fieldText = "__<" + this.type + "> " + this.fieldName + ';';
        String commentContinuation = '\n' + StringsKt.repeat((CharSequence)" ", (int)fieldText.length()) + " // ";
        return fieldText + " // " + StringsKt.replace$default((String)this.name, (String)"\n", (String)commentContinuation, (boolean)false, (int)4, null);
    }

    @NotNull
    public final TypeSetBuilderImpl component1() {
        return this.block;
    }

    public final int component2() {
        return this.index;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final String component4() {
        return this.type;
    }

    @NotNull
    public final TypeDefinition copy(@NotNull TypeSetBuilderImpl block, int index, @NotNull String name, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new TypeDefinition(block, index, name, type);
    }

    public static /* synthetic */ TypeDefinition copy$default(TypeDefinition typeDefinition, TypeSetBuilderImpl typeSetBuilderImpl, int n, String string, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            typeSetBuilderImpl = typeDefinition.block;
        }
        if ((n2 & 2) != 0) {
            n = typeDefinition.index;
        }
        if ((n2 & 4) != 0) {
            string = typeDefinition.name;
        }
        if ((n2 & 8) != 0) {
            string2 = typeDefinition.type;
        }
        return typeDefinition.copy(typeSetBuilderImpl, n, string, string2);
    }

    @NotNull
    public String toString() {
        return "TypeDefinition(block=" + this.block + ", index=" + this.index + ", name=" + this.name + ", type=" + this.type + ')';
    }

    public int hashCode() {
        int result = this.block.hashCode();
        result = result * 31 + Integer.hashCode(this.index);
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.type.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeDefinition)) {
            return false;
        }
        TypeDefinition typeDefinition = (TypeDefinition)other;
        if (!Intrinsics.areEqual((Object)this.block, (Object)typeDefinition.block)) {
            return false;
        }
        if (this.index != typeDefinition.index) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)typeDefinition.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.type, (Object)typeDefinition.type);
    }
}

