/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.reflectcase;

import dev.thecodewarrior.reflectcase.EasyReflect;
import dev.thecodewarrior.reflectcase.TestSources;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\b'\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0001\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010)\u001a\b\u0012\u0004\u0012\u0002H*0\u0007\"\u0006\b\u0000\u0010*\u0018\u0001H\u0084\bJ\b\u0010+\u001a\u00020,H\u0003J\b\u0010-\u001a\u00020,H\u0003J\b\u0010.\u001a\u00020\u001bH\u0002J\b\u0010/\u001a\u00020,H\u0014J;\u00100\u001a\u0002H*\"\u0004\b\u0000\u0010**\u0006\u0012\u0002\b\u00030\u00072\u0006\u00101\u001a\u00020\u00042\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0003\"\u0004\u0018\u00010\u0001H\u0004\u00a2\u0006\u0002\u00103J9\u00100\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020&2\b\u00104\u001a\u0004\u0018\u00010\u00012\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0003\"\u0004\u0018\u00010\u0001H\u0004\u00a2\u0006\u0002\u00105J7\u00100\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020\u00012\u0006\u00101\u001a\u00020\u00042\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0003\"\u0004\u0018\u00010\u0001H\u0004\u00a2\u0006\u0002\u00106J\u001c\u00107\u001a\u0006\u0012\u0002\b\u00030\u0007*\u0006\u0012\u0002\b\u00030\u00072\u0006\u00101\u001a\u00020\u0004H\u0004J5\u00108\u001a\u0006\u0012\u0002\b\u00030!*\u0006\u0012\u0002\b\u00030\u00072\u001a\u00109\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0003\"\u0006\u0012\u0002\b\u00030\u0007H\u0004\u00a2\u0006\u0002\u0010:J\u0018\u0010;\u001a\u00020<*\u0006\u0012\u0002\b\u00030\u00072\u0006\u00101\u001a\u00020\u0004H\u0004J#\u0010=\u001a\u0002H*\"\u0004\b\u0000\u0010**\u0006\u0012\u0002\b\u00030\u00072\u0006\u00101\u001a\u00020\u0004H\u0004\u00a2\u0006\u0002\u0010>J!\u0010=\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020<2\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0004\u00a2\u0006\u0002\u0010?J\u001f\u0010=\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020\u00012\u0006\u00101\u001a\u00020\u0004H\u0004\u00a2\u0006\u0002\u0010@J9\u0010A\u001a\u00020&*\u0006\u0012\u0002\b\u00030\u00072\u0006\u00101\u001a\u00020\u00042\u001a\u00109\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0003\"\u0006\u0012\u0002\b\u00030\u0007H\u0004\u00a2\u0006\u0002\u0010BJ3\u0010C\u001a\u0002H*\"\u0004\b\u0000\u0010**\u0006\u0012\u0002\b\u00030\u00072\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0003\"\u0004\u0018\u00010\u0001H\u0004\u00a2\u0006\u0002\u0010DJ3\u0010E\u001a\u0002H*\"\u0004\b\u0000\u0010**\u0006\u0012\u0002\b\u00030!2\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0003\"\u0004\u0018\u00010\u0001H\u0004\u00a2\u0006\u0002\u0010FJ\"\u0010G\u001a\u00020,*\u0006\u0012\u0002\b\u00030\u00072\u0006\u00101\u001a\u00020\u00042\b\u0010H\u001a\u0004\u0018\u00010\u0001H\u0004J \u0010G\u001a\u00020,*\u00020<2\b\u00104\u001a\u0004\u0018\u00010\u00012\b\u0010H\u001a\u0004\u0018\u00010\u0001H\u0004J\u001e\u0010G\u001a\u00020,*\u00020\u00012\u0006\u00101\u001a\u00020\u00042\b\u0010H\u001a\u0004\u0018\u00010\u0001H\u0004R\u0018\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0018\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0018\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0018\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0018\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0018\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0018\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u0018\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u0006\u0012\u0002\b\u00030!*\u0006\u0012\u0002\b\u00030\"8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\u00020&*\u0006\u0012\u0002\b\u00030\"8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006I"}, d2={"Ldev/thecodewarrior/reflectcase/ReflectTest;", "", "globalImports", "", "", "([Ljava/lang/String;)V", "_boolean", "Ljava/lang/Class;", "get_boolean", "()Ljava/lang/Class;", "_byte", "get_byte", "_char", "get_char", "_double", "get_double", "_float", "get_float", "_int", "get_int", "_long", "get_long", "_object", "get_object", "_short", "get_short", "_sources", "Ldev/thecodewarrior/reflectcase/TestSources;", "[Ljava/lang/String;", "sources", "getSources", "()Ldev/thecodewarrior/reflectcase/TestSources;", "c", "Ljava/lang/reflect/Constructor;", "Lkotlin/reflect/KFunction;", "getC", "(Lkotlin/reflect/KFunction;)Ljava/lang/reflect/Constructor;", "m", "Ljava/lang/reflect/Method;", "getM", "(Lkotlin/reflect/KFunction;)Ljava/lang/reflect/Method;", "_c", "T", "beforeEachTest", "", "compileSources", "createSources", "initializeForTest", "_call", "name", "arguments", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "instance", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "_class", "_constructor", "parameters", "(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", "_f", "Ljava/lang/reflect/Field;", "_get", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "_m", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "_new", "(Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "_newInstance", "(Ljava/lang/reflect/Constructor;[Ljava/lang/Object;)Ljava/lang/Object;", "_set", "value", "reflectcase"})
public abstract class ReflectTest {
    @NotNull
    private final String[] globalImports;
    @NotNull
    private TestSources _sources;
    @NotNull
    private final Class<?> _boolean;
    @NotNull
    private final Class<?> _byte;
    @NotNull
    private final Class<?> _char;
    @NotNull
    private final Class<?> _short;
    @NotNull
    private final Class<?> _int;
    @NotNull
    private final Class<?> _long;
    @NotNull
    private final Class<?> _float;
    @NotNull
    private final Class<?> _double;
    @NotNull
    private final Class<?> _object;

    public ReflectTest(String ... globalImports) {
        Intrinsics.checkNotNullParameter((Object)globalImports, (String)"globalImports");
        this.globalImports = globalImports;
        this._sources = this.createSources();
        Class<Boolean> clazz = Boolean.TYPE;
        Intrinsics.checkNotNull(clazz);
        this._boolean = clazz;
        Class<Byte> clazz2 = Byte.TYPE;
        Intrinsics.checkNotNull(clazz2);
        this._byte = clazz2;
        Class<Character> clazz3 = Character.TYPE;
        Intrinsics.checkNotNull(clazz3);
        this._char = clazz3;
        Class<Short> clazz4 = Short.TYPE;
        Intrinsics.checkNotNull(clazz4);
        this._short = clazz4;
        Class<Integer> clazz5 = Integer.TYPE;
        Intrinsics.checkNotNull(clazz5);
        this._int = clazz5;
        Class<Long> clazz6 = Long.TYPE;
        Intrinsics.checkNotNull(clazz6);
        this._long = clazz6;
        Class<Float> clazz7 = Float.TYPE;
        Intrinsics.checkNotNull(clazz7);
        this._float = clazz7;
        Class<Double> clazz8 = Double.TYPE;
        Intrinsics.checkNotNull(clazz8);
        this._double = clazz8;
        this._object = Object.class;
    }

    protected void initializeForTest() {
    }

    @NotNull
    protected final TestSources getSources() {
        return this._sources;
    }

    protected final /* synthetic */ <T> Class<T> _c() {
        boolean $i$f$_c = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return Object.class;
    }

    @NotNull
    protected final Class<?> get_boolean() {
        return this._boolean;
    }

    @NotNull
    protected final Class<?> get_byte() {
        return this._byte;
    }

    @NotNull
    protected final Class<?> get_char() {
        return this._char;
    }

    @NotNull
    protected final Class<?> get_short() {
        return this._short;
    }

    @NotNull
    protected final Class<?> get_int() {
        return this._int;
    }

    @NotNull
    protected final Class<?> get_long() {
        return this._long;
    }

    @NotNull
    protected final Class<?> get_float() {
        return this._float;
    }

    @NotNull
    protected final Class<?> get_double() {
        return this._double;
    }

    @NotNull
    protected final Class<?> get_object() {
        return this._object;
    }

    @NotNull
    protected final Method _m(@NotNull Class<?> $this$_m, @NotNull String name, Class<?> ... parameters) {
        Intrinsics.checkNotNullParameter($this$_m, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return EasyReflect.INSTANCE.findMethod($this$_m, name, Arrays.copyOf(parameters, parameters.length));
    }

    @NotNull
    protected final Constructor<?> _constructor(@NotNull Class<?> $this$_constructor, Class<?> ... parameters) {
        Intrinsics.checkNotNullParameter($this$_constructor, (String)"<this>");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return EasyReflect.INSTANCE.findConstructor($this$_constructor, Arrays.copyOf(parameters, parameters.length));
    }

    @NotNull
    protected final Field _f(@NotNull Class<?> $this$_f, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$_f, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Field field = $this$_f.getDeclaredField(name);
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"this.getDeclaredField(name)");
        return field;
    }

    @NotNull
    protected final Class<?> _class(@NotNull Class<?> $this$_class, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$_class, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return EasyReflect.INSTANCE.getClass($this$_class, name);
    }

    protected final <T> T _new(@NotNull Class<?> $this$_new, Object ... arguments) {
        Intrinsics.checkNotNullParameter($this$_new, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return EasyReflect.INSTANCE.newInstance($this$_new, Arrays.copyOf(arguments, arguments.length));
    }

    protected final <T> T _newInstance(@NotNull Constructor<?> $this$_newInstance, Object ... arguments) {
        Intrinsics.checkNotNullParameter($this$_newInstance, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return EasyReflect.INSTANCE.newInstance($this$_newInstance, Arrays.copyOf(arguments, arguments.length));
    }

    protected final <T> T _call(@NotNull Method $this$_call, @Nullable Object instance, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)$this$_call, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return EasyReflect.INSTANCE.call($this$_call, instance, Arrays.copyOf(arguments, arguments.length));
    }

    protected final <T> T _call(@NotNull Object $this$_call, @NotNull String name, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)$this$_call, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return EasyReflect.INSTANCE.findAndCall($this$_call, name, Arrays.copyOf(arguments, arguments.length));
    }

    protected final <T> T _call(@NotNull Class<?> $this$_call, @NotNull String name, Object ... arguments) {
        Intrinsics.checkNotNullParameter($this$_call, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return EasyReflect.INSTANCE.findAndCallStatic($this$_call, name, Arrays.copyOf(arguments, arguments.length));
    }

    protected final <T> T _get(@NotNull Field $this$_get, @Nullable Object instance) {
        Intrinsics.checkNotNullParameter((Object)$this$_get, (String)"<this>");
        return EasyReflect.INSTANCE.get($this$_get, instance);
    }

    protected final void _set(@NotNull Field $this$_set, @Nullable Object instance, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)$this$_set, (String)"<this>");
        EasyReflect.INSTANCE.set($this$_set, instance, value);
    }

    protected final <T> T _get(@NotNull Object $this$_get, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$_get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return EasyReflect.INSTANCE.findAndGet($this$_get, name);
    }

    protected final void _set(@NotNull Object $this$_set, @NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)$this$_set, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        EasyReflect.INSTANCE.findAndSet($this$_set, name, value);
    }

    protected final <T> T _get(@NotNull Class<?> $this$_get, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$_get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return EasyReflect.INSTANCE.findAndGetStatic($this$_get, name);
    }

    protected final void _set(@NotNull Class<?> $this$_set, @NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter($this$_set, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        EasyReflect.INSTANCE.findAndSetStatic($this$_set, name, value);
    }

    @NotNull
    protected final Method getM(@NotNull KFunction<?> $this$m) {
        Intrinsics.checkNotNullParameter($this$m, (String)"<this>");
        Method method = ReflectJvmMapping.getJavaMethod($this$m);
        Intrinsics.checkNotNull((Object)method);
        return method;
    }

    @NotNull
    protected final Constructor<?> getC(@NotNull KFunction<?> $this$c) {
        Intrinsics.checkNotNullParameter($this$c, (String)"<this>");
        Constructor constructor = ReflectJvmMapping.getJavaConstructor($this$c);
        Intrinsics.checkNotNull((Object)constructor);
        return constructor;
    }

    @BeforeAll
    private final void compileSources() {
        this.getSources().compile();
    }

    @BeforeEach
    private final void beforeEachTest() {
        this._sources = this.createSources();
        this.initializeForTest();
    }

    private final TestSources createSources() {
        TestSources sources = TestSources.Companion.create();
        CollectionsKt.addAll((Collection)sources.getGlobalImports(), (Object[])this.globalImports);
        return sources;
    }
}

