/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.prism.base.analysis;

import java.util.ArrayList;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0011\u0010\u000f\u001a\u00020\u0010\"\u0006\b\u0000\u0010\u0011\u0018\u0001H\u0086\bJ\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000bJ\b\u0010\u0015\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/thecodewarrior/prism/base/analysis/AnalysisLog;", "", "()V", "entries", "", "Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$LogEntry;", "log", "", "severity", "Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$Severity;", "source", "", "message", "cause", "", "logger", "Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$AnalysisLogger;", "T", "clazz", "Ljava/lang/Class;", "name", "toString", "AnalysisLogger", "AnalysisLoggerImpl", "LogEntry", "Severity", "prism"})
public final class AnalysisLog {
    @NotNull
    private final List<LogEntry> entries = new ArrayList();

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.entries, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final AnalysisLogger logger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new AnalysisLoggerImpl(name);
    }

    @NotNull
    public final AnalysisLogger logger(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String string = clazz.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.simpleName");
        return this.logger(string);
    }

    public final /* synthetic */ <T> AnalysisLogger logger() {
        boolean $i$f$logger = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.logger(Object.class);
    }

    private final void log(Severity severity, String source, String message, Throwable cause) {
        this.entries.add(new LogEntry(severity, source, message, cause));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001c"}, d2={"Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$LogEntry;", "", "severity", "Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$Severity;", "source", "", "message", "cause", "", "(Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$Severity;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "getCause", "()Ljava/lang/Throwable;", "getMessage", "()Ljava/lang/String;", "getSeverity", "()Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$Severity;", "getSource", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "prism"})
    private static final class LogEntry {
        @NotNull
        private final Severity severity;
        @NotNull
        private final String source;
        @NotNull
        private final String message;
        @Nullable
        private final Throwable cause;

        public LogEntry(@NotNull Severity severity, @NotNull String source, @NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.severity = severity;
            this.source = source;
            this.message = message;
            this.cause = cause;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final Throwable getCause() {
            return this.cause;
        }

        @NotNull
        public String toString() {
            return "" + '[' + (Object)((Object)this.severity) + "] [" + this.source + "] " + this.message + (this.cause == null ? "" : Intrinsics.stringPlus((String)"\n", (Object)ExceptionsKt.stackTraceToString((Throwable)this.cause)));
        }

        @NotNull
        public final Severity component1() {
            return this.severity;
        }

        @NotNull
        public final String component2() {
            return this.source;
        }

        @NotNull
        public final String component3() {
            return this.message;
        }

        @Nullable
        public final Throwable component4() {
            return this.cause;
        }

        @NotNull
        public final LogEntry copy(@NotNull Severity severity, @NotNull String source, @NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new LogEntry(severity, source, message, cause);
        }

        public static /* synthetic */ LogEntry copy$default(LogEntry logEntry, Severity severity, String string, String string2, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                severity = logEntry.severity;
            }
            if ((n & 2) != 0) {
                string = logEntry.source;
            }
            if ((n & 4) != 0) {
                string2 = logEntry.message;
            }
            if ((n & 8) != 0) {
                throwable = logEntry.cause;
            }
            return logEntry.copy(severity, string, string2, throwable);
        }

        public int hashCode() {
            int result = this.severity.hashCode();
            result = result * 31 + this.source.hashCode();
            result = result * 31 + this.message.hashCode();
            result = result * 31 + (this.cause == null ? 0 : this.cause.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LogEntry)) {
                return false;
            }
            LogEntry logEntry = (LogEntry)other;
            if (this.severity != logEntry.severity) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.source, (Object)logEntry.source)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)logEntry.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cause, (Object)logEntry.cause);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$Severity;", "", "(Ljava/lang/String;I)V", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "prism"})
    private static final class Severity
    extends Enum<Severity> {
        public static final /* enum */ Severity DEBUG = new Severity();
        public static final /* enum */ Severity INFO = new Severity();
        public static final /* enum */ Severity WARN = new Severity();
        public static final /* enum */ Severity ERROR = new Severity();
        public static final /* enum */ Severity FATAL = new Severity();
        private static final /* synthetic */ Severity[] $VALUES;

        public static Severity[] values() {
            return (Severity[])$VALUES.clone();
        }

        public static Severity valueOf(String value) {
            return Enum.valueOf(Severity.class, value);
        }

        static {
            $VALUES = severityArray = new Severity[]{Severity.DEBUG, Severity.INFO, Severity.WARN, Severity.ERROR, Severity.FATAL};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001a\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001a\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001a\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001a\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$AnalysisLogger;", "", "debug", "", "message", "", "cause", "", "error", "fatal", "info", "warn", "prism"})
    public static interface AnalysisLogger {
        public void debug(@NotNull String var1);

        public void debug(@NotNull String var1, @Nullable Throwable var2);

        public void info(@NotNull String var1);

        public void info(@NotNull String var1, @Nullable Throwable var2);

        public void warn(@NotNull String var1);

        public void warn(@NotNull String var1, @Nullable Throwable var2);

        public void error(@NotNull String var1);

        public void error(@NotNull String var1, @Nullable Throwable var2);

        public void fatal(@NotNull String var1);

        public void fatal(@NotNull String var1, @Nullable Throwable var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001a\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001a\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001a\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$AnalysisLoggerImpl;", "Ldev/thecodewarrior/prism/base/analysis/AnalysisLog$AnalysisLogger;", "source", "", "(Ldev/thecodewarrior/prism/base/analysis/AnalysisLog;Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "debug", "", "message", "cause", "", "error", "fatal", "info", "warn", "prism"})
    private final class AnalysisLoggerImpl
    implements AnalysisLogger {
        @NotNull
        private final String source;

        public AnalysisLoggerImpl(String source) {
            Intrinsics.checkNotNullParameter((Object)AnalysisLog.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @Override
        public void debug(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.debug(message, null);
        }

        @Override
        public void debug(@NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            AnalysisLog.this.log(Severity.DEBUG, this.source, message, cause);
        }

        @Override
        public void info(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.info(message, null);
        }

        @Override
        public void info(@NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            AnalysisLog.this.log(Severity.INFO, this.source, message, cause);
        }

        @Override
        public void warn(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.warn(message, null);
        }

        @Override
        public void warn(@NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            AnalysisLog.this.log(Severity.WARN, this.source, message, cause);
        }

        @Override
        public void error(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.error(message, null);
        }

        @Override
        public void error(@NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            AnalysisLog.this.log(Severity.ERROR, this.source, message, cause);
        }

        @Override
        public void fatal(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.fatal(message, null);
        }

        @Override
        public void fatal(@NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            AnalysisLog.this.log(Severity.FATAL, this.source, message, cause);
        }
    }
}

