/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.prism;

import dev.thecodewarrior.mirror.type.ConcreteTypeMirror;
import dev.thecodewarrior.prism.Prism;
import dev.thecodewarrior.prism.Serializer;
import dev.thecodewarrior.prism.TypeReader;
import dev.thecodewarrior.prism.TypeWriter;
import dev.thecodewarrior.prism.base.analysis.AnalysisLog;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u0004*\u000e\b\u0002\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00010\u0006*\f\b\u0003\u0010\u0007*\u0006\u0012\u0002\b\u00030\b2\u00020\u0002B\u001b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0019\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u001aJ\r\u0010\u001b\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010\u001cJ\u000b\u0010\u001d\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001e\u001a\u00028\u00022\u0006\u0010\u001f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00028\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00028\u0002\u00a2\u0006\u0002\u0010&R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/thecodewarrior/prism/TypeAnalyzer;", "T", "", "R", "Ldev/thecodewarrior/prism/TypeReader;", "W", "Ldev/thecodewarrior/prism/TypeWriter;", "S", "Ldev/thecodewarrior/prism/Serializer;", "prism", "Ldev/thecodewarrior/prism/Prism;", "type", "Ldev/thecodewarrior/mirror/type/ConcreteTypeMirror;", "(Ldev/thecodewarrior/prism/Prism;Ldev/thecodewarrior/mirror/type/ConcreteTypeMirror;)V", "log", "Ldev/thecodewarrior/prism/base/analysis/AnalysisLog;", "getLog", "()Ldev/thecodewarrior/prism/base/analysis/AnalysisLog;", "getPrism", "()Ldev/thecodewarrior/prism/Prism;", "readerPool", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getType", "()Ldev/thecodewarrior/mirror/type/ConcreteTypeMirror;", "writerPool", "createReader", "()Ldev/thecodewarrior/prism/TypeReader;", "createWriter", "()Ldev/thecodewarrior/prism/TypeWriter;", "getReader", "getWriter", "value", "(Ljava/lang/Object;)Ldev/thecodewarrior/prism/TypeWriter;", "release", "", "reader", "(Ldev/thecodewarrior/prism/TypeReader;)V", "writer", "(Ldev/thecodewarrior/prism/TypeWriter;)V"})
public abstract class TypeAnalyzer<T, R extends TypeReader<T>, W extends TypeWriter<T>, S extends Serializer<?>> {
    @NotNull
    private final Prism<S> prism;
    @NotNull
    private final ConcreteTypeMirror type;
    @NotNull
    private final AnalysisLog log;
    @NotNull
    private final ConcurrentLinkedQueue<R> readerPool;
    @NotNull
    private final ConcurrentLinkedQueue<W> writerPool;

    public TypeAnalyzer(@NotNull Prism<S> prism, @NotNull ConcreteTypeMirror type) {
        Intrinsics.checkNotNullParameter(prism, (String)"prism");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.prism = prism;
        this.type = type;
        this.log = new AnalysisLog();
        this.readerPool = new ConcurrentLinkedQueue();
        this.writerPool = new ConcurrentLinkedQueue();
    }

    @NotNull
    public final Prism<S> getPrism() {
        return this.prism;
    }

    @NotNull
    public final ConcreteTypeMirror getType() {
        return this.type;
    }

    @NotNull
    protected final AnalysisLog getLog() {
        return this.log;
    }

    @NotNull
    protected abstract R createReader();

    @NotNull
    protected abstract W createWriter();

    @NotNull
    public final R getReader() {
        TypeReader typeReader = (TypeReader)this.readerPool.poll();
        return (R)(typeReader == null ? this.createReader() : typeReader);
    }

    @NotNull
    public final W getWriter(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        TypeWriter typeWriter = (TypeWriter)this.writerPool.poll();
        TypeWriter<Object> writer = typeWriter == null ? this.createWriter() : typeWriter;
        writer.load(value);
        return (W)writer;
    }

    public final void release(@NotNull R reader) {
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        this.readerPool.add(reader);
    }

    public final void release(@NotNull W writer) {
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.writerPool.add(writer);
    }
}

