/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.mirror.impl.utils;

import dev.thecodewarrior.mirror.impl.utils.ReflectionUtilsKt;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001b\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a)\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0010H\u0000\u00a2\u0006\u0002\u0010\u0011\u001a!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0000\u00a2\u0006\u0002\u0010\u0013\u001a!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\u0017\u0010\u0017\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00180\u0010H\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00180\rH\u0000\"\u001c\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001a"}, d2={"jvmName", "", "Ljava/lang/Class;", "getJvmName", "(Ljava/lang/Class;)Ljava/lang/String;", "executableSortHash", "", "executable", "Ljava/lang/reflect/Executable;", "fieldSortHash", "field", "Ljava/lang/reflect/Field;", "stableSort", "", "Ljava/lang/reflect/Constructor;", "constructors", "", "([Ljava/lang/reflect/Constructor;)Ljava/util/List;", "fields", "([Ljava/lang/reflect/Field;)Ljava/util/List;", "Ljava/lang/reflect/Method;", "methods", "([Ljava/lang/reflect/Method;)Ljava/util/List;", "annotationString", "", "([Ljava/lang/annotation/Annotation;)Ljava/lang/String;", "mirror"})
public final class ReflectionUtilsKt {
    private static final int executableSortHash(Executable executable) {
        int result = 0;
        result = executable.getDeclaringClass().getName().hashCode();
        result = 31 * result + executable.getName().hashCode();
        Class<?>[] classArray = executable.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"executable.parameterTypes");
        Object[] $this$forEach$iv = classArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class it = (Class)element$iv;
            boolean bl = false;
            result = 31 * result + it.getName().hashCode();
        }
        if (executable instanceof Method) {
            result = 31 * result + ((Method)executable).getReturnType().getName().hashCode();
        }
        return result;
    }

    private static final int fieldSortHash(Field field) {
        int result = field.getDeclaringClass().getName().hashCode();
        result = 31 * result + field.getName().hashCode();
        return result;
    }

    @NotNull
    public static final List<Method> stableSort(@NotNull Method[] methods2) {
        Intrinsics.checkNotNullParameter((Object)methods2, (String)"methods");
        Object[] $this$sortedBy$iv = methods2;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Method it = (Method)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(ReflectionUtilsKt.access$executableSortHash(it));
                it = (Method)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ReflectionUtilsKt.access$executableSortHash(it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    @NotNull
    public static final List<Constructor<?>> stableSort(@NotNull Constructor<?>[] constructors) {
        Intrinsics.checkNotNullParameter(constructors, (String)"constructors");
        Object[] $this$sortedBy$iv = constructors;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Constructor it = (Constructor)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(ReflectionUtilsKt.access$executableSortHash(it));
                it = (Constructor)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ReflectionUtilsKt.access$executableSortHash(it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    @NotNull
    public static final List<Field> stableSort(@NotNull Field[] fields2) {
        Intrinsics.checkNotNullParameter((Object)fields2, (String)"fields");
        Object[] $this$sortedBy$iv = fields2;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Field it = (Field)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(ReflectionUtilsKt.access$fieldSortHash(it));
                it = (Field)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ReflectionUtilsKt.access$fieldSortHash(it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    @NotNull
    public static final String getJvmName(@NotNull Class<?> $this$jvmName) {
        String string;
        Intrinsics.checkNotNullParameter($this$jvmName, (String)"<this>");
        Class<?> clazz = $this$jvmName;
        if (Intrinsics.areEqual(clazz, Byte.TYPE)) {
            string = "B";
        } else if (Intrinsics.areEqual(clazz, Character.TYPE)) {
            string = "C";
        } else if (Intrinsics.areEqual(clazz, Double.TYPE)) {
            string = "D";
        } else if (Intrinsics.areEqual(clazz, Float.TYPE)) {
            string = "F";
        } else if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
            string = "I";
        } else if (Intrinsics.areEqual(clazz, Long.TYPE)) {
            string = "J";
        } else if (Intrinsics.areEqual(clazz, Short.TYPE)) {
            string = "S";
        } else if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
            string = "Z";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append('L');
            String string2 = $this$jvmName.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.name");
            string = stringBuilder.append(StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null)).append(';').toString();
        }
        return string;
    }

    @NotNull
    public static final String annotationString(@NotNull List<? extends Annotation> $this$annotationString) {
        Intrinsics.checkNotNullParameter($this$annotationString, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$annotationString, (CharSequence)"", null, null, (int)0, null, (Function1)annotationString.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String annotationString(@NotNull Annotation[] $this$annotationString) {
        Intrinsics.checkNotNullParameter((Object)$this$annotationString, (String)"<this>");
        return ArraysKt.joinToString$default((Object[])$this$annotationString, (CharSequence)"", null, null, (int)0, null, (Function1)annotationString.2.INSTANCE, (int)30, null);
    }

    public static final /* synthetic */ int access$executableSortHash(Executable executable) {
        return ReflectionUtilsKt.executableSortHash(executable);
    }

    public static final /* synthetic */ int access$fieldSortHash(Field field) {
        return ReflectionUtilsKt.fieldSortHash(field);
    }
}

