/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.mirror.impl.util;

import dev.thecodewarrior.mirror.impl.util.AbstractAnnotationListImpl;
import dev.thecodewarrior.mirror.impl.utils.CollectionsUtilExtensionsKt;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB%\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0003H\u0096\u0003J\u0017\u0010\u0014\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0096\u0001J'\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0011\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u000eH\u0096\u0003J+\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001e\"\b\b\u0000\u0010\u0018*\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0011\u0010 \u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0003H\u0096\u0001J\t\u0010!\u001a\u00020\u0007H\u0096\u0001J\u0018\u0010\"\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001aH\u0016J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$H\u0096\u0003J\u0011\u0010%\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0003H\u0096\u0001J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0096\u0001J\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010\u001c\u001a\u00020\u000eH\u0096\u0001J\u001f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000eH\u0096\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Ldev/thecodewarrior/mirror/impl/util/ElementBackedAnnotationListImpl;", "Ldev/thecodewarrior/mirror/impl/util/AbstractAnnotationListImpl;", "", "", "element", "Ljava/lang/reflect/AnnotatedElement;", "useDeclared", "", "(Ljava/lang/reflect/AnnotatedElement;Z)V", "backingList", "(Ljava/lang/reflect/AnnotatedElement;ZLjava/util/List;)V", "getElement", "()Ljava/lang/reflect/AnnotatedElement;", "size", "", "getSize", "()I", "getUseDeclared", "()Z", "contains", "containsAll", "elements", "", "get", "T", "annotationClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/annotation/Annotation;", "index", "getAllByType", "", "(Ljava/lang/Class;)[Ljava/lang/annotation/Annotation;", "indexOf", "isEmpty", "isPresent", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "mirror"})
public final class ElementBackedAnnotationListImpl
extends AbstractAnnotationListImpl
implements List<Annotation>,
KMappedMarker {
    @NotNull
    private final AnnotatedElement element;
    private final boolean useDeclared;
    private final /* synthetic */ List<Annotation> $$delegate_0;

    private ElementBackedAnnotationListImpl(AnnotatedElement element, boolean useDeclared, List<? extends Annotation> backingList) {
        this.element = element;
        this.useDeclared = useDeclared;
        this.$$delegate_0 = backingList;
    }

    @NotNull
    public final AnnotatedElement getElement() {
        return this.element;
    }

    public final boolean getUseDeclared() {
        return this.useDeclared;
    }

    @Override
    public boolean contains(@NotNull Annotation element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.$$delegate_0.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.$$delegate_0.containsAll(elements);
    }

    @Override
    @NotNull
    public Annotation get(int index) {
        return this.$$delegate_0.get(index);
    }

    @Override
    public int indexOf(@NotNull Annotation element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.$$delegate_0.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.$$delegate_0.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Annotation> iterator() {
        return this.$$delegate_0.iterator();
    }

    @Override
    public int lastIndexOf(@NotNull Annotation element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.$$delegate_0.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<Annotation> listIterator() {
        return this.$$delegate_0.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<Annotation> listIterator(int index) {
        return this.$$delegate_0.listIterator(index);
    }

    @Override
    @NotNull
    public List<Annotation> subList(int fromIndex, int toIndex) {
        return this.$$delegate_0.subList(fromIndex, toIndex);
    }

    @Override
    public int getSize() {
        return this.$$delegate_0.size();
    }

    public ElementBackedAnnotationListImpl(@NotNull AnnotatedElement element, boolean useDeclared) {
        Annotation[] annotationArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean bl = useDeclared;
        if (bl) {
            annotationArray = element.getDeclaredAnnotations();
        } else if (!bl) {
            annotationArray = element.getAnnotations();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Annotation[] annotationArray2 = annotationArray;
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"when(useDeclared) {\n            true -> element.declaredAnnotations\n            false -> element.annotations\n        }");
        this(element, useDeclared, CollectionsUtilExtensionsKt.unmodifiableView(ArraysKt.toList((Object[])annotationArray2)));
    }

    @Override
    public boolean isPresent(@NotNull Class<? extends Annotation> annotationClass) {
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        return this.get(annotationClass) != null;
    }

    @Override
    @Nullable
    public <T extends Annotation> T get(@NotNull Class<T> annotationClass) {
        T t;
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        boolean bl = this.useDeclared;
        if (bl) {
            t = this.element.getDeclaredAnnotation(annotationClass);
        } else if (!bl) {
            t = this.element.getAnnotation(annotationClass);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return t;
    }

    @Override
    @NotNull
    public <T extends Annotation> T[] getAllByType(@NotNull Class<T> annotationClass) {
        Annotation[] annotationArray;
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        boolean bl = this.useDeclared;
        if (bl) {
            Annotation[] annotationArray2 = this.element.getDeclaredAnnotationsByType(annotationClass);
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"element.getDeclaredAnnotationsByType(annotationClass)");
            annotationArray = annotationArray2;
        } else if (!bl) {
            Annotation[] annotationArray3 = this.element.getAnnotationsByType(annotationClass);
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray3, (String)"element.getAnnotationsByType(annotationClass)");
            annotationArray = annotationArray3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return annotationArray;
    }
}

