/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.mirror.impl.coretypes;

import dev.thecodewarrior.mirror.impl.coretypes.AnnotatedArrayTypeImpl;
import dev.thecodewarrior.mirror.impl.coretypes.AnnotatedParameterizedTypeImpl;
import dev.thecodewarrior.mirror.impl.coretypes.AnnotatedTypeVariableImpl;
import dev.thecodewarrior.mirror.impl.coretypes.AnnotatedWildcardTypeImpl;
import dev.thecodewarrior.mirror.impl.coretypes.CoreTypeUtils;
import dev.thecodewarrior.mirror.impl.coretypes.GenericArrayTypeImpl;
import dev.thecodewarrior.mirror.impl.coretypes.ParameterizedTypeImpl;
import dev.thecodewarrior.mirror.impl.coretypes.WildcardTypeImpl;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class TypeVisitor {
    private final Map<TypeVariable, AnnotatedTypeVariable> varCache = new IdentityHashMap<TypeVariable, AnnotatedTypeVariable>();

    protected AnnotatedType visitParameterizedType(AnnotatedParameterizedType type2) {
        AnnotatedType[] params = (AnnotatedType[])Arrays.stream(type2.getAnnotatedActualTypeArguments()).map(param -> CoreTypeUtils.transform(param, this)).toArray(AnnotatedType[]::new);
        ParameterizedType inner = (ParameterizedType)type2.getType();
        ParameterizedTypeImpl raw = new ParameterizedTypeImpl(CoreTypeUtils.erase(inner), (Type[])Arrays.stream(params).map(AnnotatedType::getType).toArray(Type[]::new), inner.getOwnerType());
        return new AnnotatedParameterizedTypeImpl(raw, type2.getAnnotations(), params);
    }

    protected AnnotatedType visitWildcardType(AnnotatedWildcardType type2) {
        AnnotatedType[] lowerBounds2 = (AnnotatedType[])Arrays.stream(type2.getAnnotatedLowerBounds()).map(bound -> CoreTypeUtils.transform(bound, this)).toArray(AnnotatedType[]::new);
        AnnotatedType[] upperBounds2 = (AnnotatedType[])Arrays.stream(type2.getAnnotatedUpperBounds()).map(bound -> CoreTypeUtils.transform(bound, this)).toArray(AnnotatedType[]::new);
        WildcardTypeImpl inner = new WildcardTypeImpl((Type[])Arrays.stream(upperBounds2).map(AnnotatedType::getType).toArray(Type[]::new), (Type[])Arrays.stream(lowerBounds2).map(AnnotatedType::getType).toArray(Type[]::new));
        return new AnnotatedWildcardTypeImpl(inner, type2.getAnnotations(), lowerBounds2, upperBounds2);
    }

    protected AnnotatedType visitVariable(AnnotatedTypeVariable type2) {
        TypeVariable var = (TypeVariable)type2.getType();
        if (this.varCache.containsKey(var)) {
            return this.varCache.get(var);
        }
        AnnotatedTypeVariableImpl variable = new AnnotatedTypeVariableImpl(var, type2.getAnnotations());
        this.varCache.put(var, variable);
        AnnotatedType[] bounds2 = (AnnotatedType[])Arrays.stream(type2.getAnnotatedBounds()).map(bound -> CoreTypeUtils.transform(bound, this)).toArray(AnnotatedType[]::new);
        variable.init(bounds2);
        return variable;
    }

    protected AnnotatedType visitArray(AnnotatedArrayType type2) {
        AnnotatedType componentType = CoreTypeUtils.transform(type2.getAnnotatedGenericComponentType(), this);
        return new AnnotatedArrayTypeImpl(GenericArrayTypeImpl.createArrayType(componentType.getType()), type2.getAnnotations(), componentType);
    }

    protected AnnotatedType visitClass(AnnotatedType type2) {
        return type2;
    }

    protected AnnotatedType visitUnmatched(AnnotatedType type2) {
        return type2;
    }
}

