/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.mirror.impl.coretypes;

import dev.thecodewarrior.mirror.impl.coretypes.AnnotatedTypeImpl;
import dev.thecodewarrior.mirror.impl.coretypes.CoreTypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

class AnnotatedWildcardTypeImpl
extends AnnotatedTypeImpl
implements AnnotatedWildcardType {
    private AnnotatedType[] lowerBounds;
    private AnnotatedType[] upperBounds;

    AnnotatedWildcardTypeImpl(WildcardType type2, Annotation[] annotations2, AnnotatedType[] lowerBounds2, AnnotatedType[] upperBounds2) {
        super(type2, annotations2);
        if (lowerBounds2 == null || lowerBounds2.length == 0) {
            lowerBounds2 = new AnnotatedType[]{};
        }
        if (upperBounds2 == null || upperBounds2.length == 0) {
            upperBounds2 = new AnnotatedType[]{};
        }
        AnnotatedWildcardTypeImpl.validateBounds(type2, lowerBounds2, upperBounds2);
        this.lowerBounds = lowerBounds2;
        this.upperBounds = upperBounds2;
    }

    @Override
    public AnnotatedType[] getAnnotatedLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public AnnotatedType[] getAnnotatedUpperBounds() {
        return this.upperBounds;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AnnotatedWildcardType) || !super.equals(other)) {
            return false;
        }
        return CoreTypeUtils.typeArraysEqual(this.lowerBounds, ((AnnotatedWildcardType)other).getAnnotatedLowerBounds()) && CoreTypeUtils.typeArraysEqual(this.upperBounds, ((AnnotatedWildcardType)other).getAnnotatedUpperBounds());
    }

    @Override
    public int hashCode() {
        return 127 * super.hashCode() ^ CoreTypeUtils.hashCode(this.lowerBounds) + CoreTypeUtils.hashCode(this.upperBounds);
    }

    @Override
    public String toString() {
        if (this.lowerBounds.length > 0) {
            return this.annotationsString() + "? super " + this.typesString(this.lowerBounds);
        }
        if (this.upperBounds.length == 0 || this.upperBounds[0].getType() == Object.class) {
            return this.annotationsString() + "?";
        }
        return this.annotationsString() + "? extends " + this.typesString(this.upperBounds);
    }

    private static void validateBounds(WildcardType type2, AnnotatedType[] lowerBounds2, AnnotatedType[] upperBounds2) {
        int i;
        if (type2.getLowerBounds().length != lowerBounds2.length) {
            throw new IllegalArgumentException("Incompatible lower bounds " + Arrays.toString(lowerBounds2) + " for type " + type2.toString());
        }
        if ((upperBounds2.length != 0 || type2.getUpperBounds().length != 1) && type2.getUpperBounds().length != upperBounds2.length) {
            throw new IllegalArgumentException("Incompatible upper bounds " + Arrays.toString(upperBounds2) + " for type " + type2.toString());
        }
        for (i = 0; i < type2.getLowerBounds().length; ++i) {
            if (CoreTypeUtils.erase(type2.getLowerBounds()[i]) == CoreTypeUtils.erase(lowerBounds2[i].getType())) continue;
            throw new IllegalArgumentException("Bound " + lowerBounds2[i].getType() + " incompatible with " + type2.getLowerBounds()[i] + " in type " + type2.toString());
        }
        for (i = 0; i < type2.getUpperBounds().length; ++i) {
            if (upperBounds2.length == 0 || CoreTypeUtils.erase(type2.getUpperBounds()[i]) == CoreTypeUtils.erase(upperBounds2[i].getType())) continue;
            throw new IllegalArgumentException("Bound " + upperBounds2[i].getType() + " incompatible with " + type2.getUpperBounds()[i] + " in type " + type2.toString());
        }
    }
}

