/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.mirror.impl;

import dev.thecodewarrior.mirror.impl.MirrorCache;
import dev.thecodewarrior.mirror.impl.member.ConstructorMirrorImpl;
import dev.thecodewarrior.mirror.impl.member.ExecutableMirrorImpl;
import dev.thecodewarrior.mirror.impl.member.ExecutableSpecialization;
import dev.thecodewarrior.mirror.impl.member.MethodMirrorImpl;
import dev.thecodewarrior.mirror.member.ConstructorMirror;
import dev.thecodewarrior.mirror.member.ExecutableMirror;
import dev.thecodewarrior.mirror.member.MethodMirror;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/thecodewarrior/mirror/impl/ExecutableMirrorCache;", "", "cache", "Ldev/thecodewarrior/mirror/impl/MirrorCache;", "(Ldev/thecodewarrior/mirror/impl/MirrorCache;)V", "rawCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/reflect/Executable;", "Ldev/thecodewarrior/mirror/member/ExecutableMirror;", "specializedCache", "Lkotlin/Pair;", "Ldev/thecodewarrior/mirror/impl/member/ExecutableSpecialization;", "reflect", "executable", "specialize", "specialization", "mirror"})
public final class ExecutableMirrorCache {
    @NotNull
    private final MirrorCache cache;
    @NotNull
    private final ConcurrentHashMap<Executable, ExecutableMirror> rawCache;
    @NotNull
    private final ConcurrentHashMap<Pair<ExecutableMirror, ExecutableSpecialization>, ExecutableMirror> specializedCache;

    public ExecutableMirrorCache(@NotNull MirrorCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
        this.rawCache = new ConcurrentHashMap();
        this.specializedCache = new ConcurrentHashMap();
    }

    @NotNull
    public final ExecutableMirror reflect(@NotNull Executable executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        ConcurrentMap $this$getOrPut$iv = this.rawCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(executable);
        if (object == null) {
            ExecutableMirrorImpl executableMirrorImpl;
            boolean bl = false;
            Executable executable2 = executable;
            if (executable2 instanceof Constructor) {
                executableMirrorImpl = new ConstructorMirrorImpl(this.cache, (Constructor)executable, null, null);
            } else if (executable2 instanceof Method) {
                executableMirrorImpl = new MethodMirrorImpl(this.cache, (Method)executable, null, null);
            } else {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown executable ", (Object)executable));
            }
            ExecutableMirror executableMirror = executableMirrorImpl;
            boolean bl2 = false;
            boolean bl3 = false;
            ExecutableMirror default$iv = executableMirror;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(executable, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object v = object;
        Intrinsics.checkNotNullExpressionValue(v, (String)"rawCache.getOrPut(executable) {\n            when (executable) {\n                is Constructor<*> -> ConstructorMirrorImpl(cache, executable, null, null)\n                is Method -> MethodMirrorImpl(cache, executable, null, null)\n                else -> throw IllegalArgumentException(\"Unknown executable $executable\")\n            }\n        }");
        return (ExecutableMirror)v;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExecutableMirror specialize(@NotNull ExecutableMirror executable, @NotNull ExecutableSpecialization specialization) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)specialization, (String)"specialization");
        ExecutableMirror raw = executable.getRaw();
        ConcurrentMap concurrentMap = this.specializedCache;
        Pair key$iv = TuplesKt.to((Object)raw, (Object)specialization);
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            ExecutableMirrorImpl executableMirrorImpl;
            boolean bl = false;
            ExecutableMirror executableMirror = raw;
            if (executableMirror instanceof ConstructorMirror) {
                executableMirrorImpl = new ConstructorMirrorImpl(this.cache, ((ConstructorMirror)raw).getJava(), (ConstructorMirrorImpl)raw, specialization);
            } else if (executableMirror instanceof MethodMirror) {
                executableMirrorImpl = new MethodMirrorImpl(this.cache, ((MethodMirror)raw).getJava(), (MethodMirrorImpl)raw, specialization);
            } else {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown executable ", (Object)executable));
            }
            ExecutableMirror executableMirror2 = executableMirrorImpl;
            boolean bl2 = false;
            boolean bl3 = false;
            ExecutableMirror default$iv = executableMirror2;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object v = object;
        Intrinsics.checkNotNullExpressionValue(v, (String)"specializedCache.getOrPut(raw to specialization) {\n            when (raw) {\n                is ConstructorMirror -> ConstructorMirrorImpl(cache, raw.java, raw as ConstructorMirrorImpl, specialization)\n                is MethodMirror -> MethodMirrorImpl(cache, raw.java, raw as MethodMirrorImpl, specialization)\n                else -> throw IllegalArgumentException(\"Unknown executable $executable\")\n            }\n        }");
        return (ExecutableMirror)v;
    }
}

