/*
 * Decompiled with CFR 0.152.
 */
package dev.teogor.sudoklify.utils;

import dev.teogor.sudoklify.model.GameType;
import dev.teogor.sudoklify.model.SudokuSolution;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0011J)\u0010\u000f\u001a\u00020\u00122\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0014J3\u0010\u0015\u001a\u00020\u00162\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u001b\u0010\u001d\u001a\u00020\u00162\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u000b\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\r0\fj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/teogor/sudoklify/utils/SudokuSolver;", "", "grid", "", "", "gameType", "Ldev/teogor/sudoklify/model/GameType;", "([[ILdev/teogor/sudoklify/model/GameType;)V", "[[I", "stepCount", "", "steps", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lkotlin/collections/ArrayList;", "copyGrid", "sourceGrid", "([[I)[[I", "", "destinationGrid", "([[I[[I)V", "isValid", "", "row", "col", "num", "([[IIII)Z", "solve", "Ldev/teogor/sudoklify/model/SudokuSolution;", "solveSudoku", "([[I)Z", "sudoklify"})
public final class SudokuSolver {
    @NotNull
    private final int[][] grid;
    @NotNull
    private final GameType gameType;
    @NotNull
    private final ArrayList<Pair<Integer, Integer>> steps;
    private int stepCount;

    public SudokuSolver(@NotNull int[][] grid, @NotNull GameType gameType) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)((Object)gameType), (String)"gameType");
        this.grid = grid;
        this.gameType = gameType;
        this.steps = new ArrayList();
    }

    @NotNull
    public final SudokuSolution solve() {
        long startTime = System.nanoTime();
        int[][] workingGrid = this.copyGrid(this.grid);
        boolean solved = this.solveSudoku(workingGrid);
        long endTime = System.nanoTime();
        long elapsedTime = endTime - startTime;
        if (solved) {
            this.copyGrid(workingGrid, this.grid);
        }
        return new SudokuSolution(elapsedTime, solved, this.stepCount, workingGrid);
    }

    private final void copyGrid(int[][] sourceGrid, int[][] destinationGrid) {
        int n = ((Object[])sourceGrid).length;
        for (int row = 0; row < n; ++row) {
            int n2 = sourceGrid[row].length;
            for (int col = 0; col < n2; ++col) {
                destinationGrid[row][col] = sourceGrid[row][col];
            }
        }
    }

    private final int[][] copyGrid(int[][] sourceGrid) {
        int n = 0;
        int n2 = ((Object[])sourceGrid).length;
        int[][] nArrayArray = new int[n2][];
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = new int[sourceGrid[0].length];
        }
        int[][] newGrid = nArrayArray;
        this.copyGrid(sourceGrid, newGrid);
        return newGrid;
    }

    private final boolean solveSudoku(int[][] grid) {
        int n = this.stepCount;
        this.stepCount = n + 1;
        int n2 = ((Object[])grid).length;
        for (int row = 0; row < n2; ++row) {
            int n3 = grid[row].length;
            for (int col = 0; col < n3; ++col) {
                if (grid[row][col] != 0) continue;
                int num = 1;
                int n4 = this.gameType.getCells();
                if (num <= n4) {
                    while (true) {
                        if (this.isValid(grid, row, col, num)) {
                            grid[row][col] = num;
                            this.steps.add((Pair<Integer, Integer>)new Pair((Object)row, (Object)col));
                            if (this.solveSudoku(grid)) {
                                return true;
                            }
                            grid[row][col] = 0;
                            CollectionsKt.removeLast((List)this.steps);
                        }
                        if (num == n4) break;
                        ++num;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private final boolean isValid(int[][] grid, int row, int col, int num) {
        int n = this.gameType.getCells();
        for (int i = 0; i < n; ++i) {
            if (grid[row][i] != num && grid[i][col] != num) continue;
            return false;
        }
        int rowStart = row / this.gameType.getGridHeight() * this.gameType.getGridHeight();
        int colStart = col / this.gameType.getGridWidth() * this.gameType.getGridWidth();
        int n2 = rowStart + this.gameType.getGridHeight();
        for (int i = rowStart; i < n2; ++i) {
            int n3 = colStart + this.gameType.getGridWidth();
            for (int j = colStart; j < n3; ++j) {
                if (grid[i][j] != num) continue;
                return false;
            }
        }
        return true;
    }
}

