/*
 * Decompiled with CFR 0.152.
 */
package dev.teogor.sudoklify;

import dev.teogor.sudoklify.extensions.SudokuBoardExtensionsKt;
import dev.teogor.sudoklify.model.GameType;
import dev.teogor.sudoklify.utils.TokenMapUtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0016\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0003j\u0002`\u000b0\n0\nj\u0002`\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0011"}, d2={"Ldev/teogor/sudoklify/SudokuParser;", "", "puzzle", "", "gameType", "Ldev/teogor/sudoklify/model/GameType;", "(Ljava/lang/String;Ldev/teogor/sudoklify/model/GameType;)V", "boxDigits", "", "puzzleBoard", "", "Ldev/teogor/sudoklify/types/Cell;", "Ldev/teogor/sudoklify/types/Board;", "[[Ljava/lang/String;", "toIntArray", "", "()[[I", "sudoklify"})
public final class SudokuParser {
    @NotNull
    private final String[][] puzzleBoard;
    private final int boxDigits;

    public SudokuParser(@NotNull String puzzle, @NotNull GameType gameType) {
        Intrinsics.checkNotNullParameter((Object)puzzle, (String)"puzzle");
        Intrinsics.checkNotNullParameter((Object)((Object)gameType), (String)"gameType");
        this.puzzleBoard = SudokuBoardExtensionsKt.toBoard(puzzle, gameType);
        this.boxDigits = gameType.getCells();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final int[][] toIntArray() {
        int n;
        Map<String, String> tokenMap = TokenMapUtilsKt.generateTokenMap(this.boxDigits);
        int n2 = 0;
        int n3 = ((Object[])this.puzzleBoard).length;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            n = n2++;
            nArrayArray[n] = new int[this.puzzleBoard[0].length];
        }
        int[][] convertedPuzzle = nArrayArray;
        n3 = ((Object[])this.puzzleBoard).length;
        for (int row = 0; row < n3; ++row) {
            n = this.puzzleBoard[row].length;
            for (int col = 0; col < n; ++col) {
                int n4;
                int[] nArray = convertedPuzzle[row];
                if (!Intrinsics.areEqual((Object)this.puzzleBoard[row][col], (Object)"-")) {
                    String value = this.puzzleBoard[row][col];
                    String string = tokenMap.get(value);
                    if (string == null) throw new IllegalArgumentException("Invalid token '" + value + "' found in Sudoku puzzle.");
                    n4 = Integer.parseInt(string);
                } else {
                    n4 = 0;
                }
                nArray[col] = n4;
            }
        }
        return convertedPuzzle;
    }
}

