/*
 * Decompiled with CFR 0.152.
 */
package dev.teogor.sudoklify.core.tokenizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tj\u0002`\bH&\u00a2\u0006\u0002\u0010\nJK\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f0\f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\fj\u0002`\u000e2\u0006\u0010\u0006\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tj\u0002`\bH&\u00a2\u0006\u0002\u0010\u0010\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Ldev/teogor/sudoklify/core/tokenizer/Tokenizer;", "", "<init>", "()V", "replaceTokens", "", "sequence", "tokenMap", "Ldev/teogor/sudoklify/common/types/TokenMap;", "", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "populateLayout", "", "layout", "Ldev/teogor/sudoklify/common/types/Layout;", "", "([[ILjava/lang/String;Ljava/util/Map;)[[Ljava/lang/String;", "Companion", "SingleDigitTokenizer", "MultiDigitTokenizer", "Ldev/teogor/sudoklify/core/tokenizer/Tokenizer$MultiDigitTokenizer;", "Ldev/teogor/sudoklify/core/tokenizer/Tokenizer$SingleDigitTokenizer;", "sudoklify-core"})
public abstract class Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Tokenizer() {
    }

    @NotNull
    public abstract String replaceTokens(@NotNull String var1, @NotNull Map<String, String> var2);

    @NotNull
    public abstract String[][] populateLayout(@NotNull int[][] var1, @NotNull String var2, @NotNull Map<String, String> var3);

    public /* synthetic */ Tokenizer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/teogor/sudoklify/core/tokenizer/Tokenizer$Companion;", "", "<init>", "()V", "create", "Ldev/teogor/sudoklify/core/tokenizer/Tokenizer;", "digits", "", "sudoklify-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Tokenizer create(int digits) {
            int n = digits;
            return (1 <= n ? n < 10 : false) ? (Tokenizer)SingleDigitTokenizer.INSTANCE : (Tokenizer)new MultiDigitTokenizer(digits);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bj\u0002`\nH\u0016\u00a2\u0006\u0002\u0010\fJK\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00110\u000ej\u0002`\u00102\u0006\u0010\b\u001a\u00020\u00072\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bj\u0002`\nH\u0016\u00a2\u0006\u0002\u0010\u0012J3\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\b\u001a\u00020\u00072\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bj\u0002`\nH\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/teogor/sudoklify/core/tokenizer/Tokenizer$MultiDigitTokenizer;", "Ldev/teogor/sudoklify/core/tokenizer/Tokenizer;", "digits", "", "<init>", "(I)V", "replaceTokens", "", "sequence", "tokenMap", "Ldev/teogor/sudoklify/common/types/TokenMap;", "", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "populateLayout", "", "layout", "Ldev/teogor/sudoklify/common/types/Layout;", "", "([[ILjava/lang/String;Ljava/util/Map;)[[Ljava/lang/String;", "extractTokens", "", "(Ljava/lang/String;Ljava/util/Map;)Ljava/util/List;", "sudoklify-core"})
    @SourceDebugExtension(value={"SMAP\nTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tokenizer.kt\ndev/teogor/sudoklify/core/tokenizer/Tokenizer$MultiDigitTokenizer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,142:1\n11102#2:143\n11437#2,2:144\n11132#2:146\n11467#2,3:147\n11439#2:152\n37#3,2:150\n37#3,2:153\n*S KotlinDebug\n*F\n+ 1 Tokenizer.kt\ndev/teogor/sudoklify/core/tokenizer/Tokenizer$MultiDigitTokenizer\n*L\n123#1:143\n123#1:144,2\n124#1:146\n124#1:147,3\n123#1:152\n127#1:150,2\n128#1:153,2\n*E\n"})
    public static final class MultiDigitTokenizer
    extends Tokenizer {
        private final int digits;

        public MultiDigitTokenizer(int digits) {
            super(null);
            this.digits = digits;
        }

        @Override
        @NotNull
        public String replaceTokens(@NotNull String sequence, @NotNull Map<String, String> tokenMap) {
            Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
            Intrinsics.checkNotNullParameter(tokenMap, (String)"tokenMap");
            Regex regex = new Regex("([A-I][a-z]+)|-|[A-I][A-I]+");
            return regex.replace((CharSequence)sequence, arg_0 -> MultiDigitTokenizer.replaceTokens$lambda$0(tokenMap, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String[][] populateLayout(@NotNull int[][] layout, @NotNull String sequence, @NotNull Map<String, String> tokenMap) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
            Intrinsics.checkNotNullParameter(tokenMap, (String)"tokenMap");
            List<String> tokens = this.extractTokens(sequence, tokenMap);
            Object $this$map$iv = (Object[])layout;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void $this$toTypedArray$iv2;
                void $this$mapTo$iv$iv2;
                void row;
                int[] nArray = (int[])item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Collection $this$map$iv2 = row;
                boolean $i$f$map2 = false;
                void var17_17 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv2).length);
                boolean $i$f$mapTo2 = false;
                int n = ((void)$this$mapTo$iv$iv2).length;
                for (int i = 0; i < n; ++i) {
                    void cell;
                    void item$iv$iv2;
                    void var23_23 = item$iv$iv2 = $this$mapTo$iv$iv2[i];
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    void index = cell < this.digits ? cell : cell - this.digits;
                    collection2.add(tokens.get((int)index));
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv2;
                collection.add(thisCollection$iv.toArray(new String[0]));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return (String[][])thisCollection$iv.toArray((T[])new String[0][]);
        }

        private final List<String> extractTokens(String sequence, Map<String, String> tokenMap) {
            Regex regex = new Regex("([A-I][a-j]+)|-|[A-I]");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)sequence, (int)0, (int)2, null), arg_0 -> MultiDigitTokenizer.extractTokens$lambda$3(tokenMap, arg_0)));
        }

        private static final CharSequence replaceTokens$lambda$0(Map $tokenMap, MatchResult matchResult) {
            Intrinsics.checkNotNullParameter((Object)$tokenMap, (String)"$tokenMap");
            Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
            String token = matchResult.getValue();
            String string = (String)$tokenMap.get(token);
            return string != null ? (CharSequence)string : (CharSequence)token;
        }

        private static final String extractTokens$lambda$3(Map $tokenMap, MatchResult match) {
            Intrinsics.checkNotNullParameter((Object)$tokenMap, (String)"$tokenMap");
            Intrinsics.checkNotNullParameter((Object)match, (String)"match");
            String string = (String)$tokenMap.get(match.getValue());
            if (string == null) {
                string = match.getValue();
            }
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tj\u0002`\bH\u0016\u00a2\u0006\u0002\u0010\nJK\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f0\f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\fj\u0002`\u000e2\u0006\u0010\u0006\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tj\u0002`\bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001\u00a8\u0006\u0018"}, d2={"Ldev/teogor/sudoklify/core/tokenizer/Tokenizer$SingleDigitTokenizer;", "Ldev/teogor/sudoklify/core/tokenizer/Tokenizer;", "<init>", "()V", "replaceTokens", "", "sequence", "tokenMap", "Ldev/teogor/sudoklify/common/types/TokenMap;", "", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "populateLayout", "", "layout", "Ldev/teogor/sudoklify/common/types/Layout;", "", "([[ILjava/lang/String;Ljava/util/Map;)[[Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "sudoklify-core"})
    @SourceDebugExtension(value={"SMAP\nTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tokenizer.kt\ndev/teogor/sudoklify/core/tokenizer/Tokenizer$SingleDigitTokenizer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,142:1\n1179#2,2:143\n11102#3:145\n11437#3,2:146\n11132#3:148\n11467#3,3:149\n11439#3:154\n37#4,2:152\n37#4,2:155\n*S KotlinDebug\n*F\n+ 1 Tokenizer.kt\ndev/teogor/sudoklify/core/tokenizer/Tokenizer$SingleDigitTokenizer\n*L\n79#1:143,2\n91#1:145\n91#1:146,2\n92#1:148\n92#1:149,3\n91#1:154\n94#1:152,2\n95#1:155,2\n*E\n"})
    public static final class SingleDigitTokenizer
    extends Tokenizer {
        @NotNull
        public static final SingleDigitTokenizer INSTANCE = new SingleDigitTokenizer();

        private SingleDigitTokenizer() {
            super(null);
        }

        @Override
        @NotNull
        public String replaceTokens(@NotNull String sequence, @NotNull Map<String, String> tokenMap) {
            Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
            Intrinsics.checkNotNullParameter(tokenMap, (String)"tokenMap");
            StringBuilder result = new StringBuilder();
            CharSequence $this$forEach$iv = sequence;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                char element$iv;
                char c = element$iv = $this$forEach$iv.charAt(i);
                boolean bl = false;
                Object object = tokenMap.get(String.valueOf(c));
                if (object == null) {
                    object = Character.valueOf(c);
                }
                result.append(object);
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String[][] populateLayout(@NotNull int[][] layout, @NotNull String sequence, @NotNull Map<String, String> tokenMap) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
            Intrinsics.checkNotNullParameter(tokenMap, (String)"tokenMap");
            String $this$populateLayout_u24lambda_u243 = this.replaceTokens(sequence, tokenMap);
            boolean bl = false;
            Object $this$map$iv = (Object[])layout;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void $this$toTypedArray$iv2;
                void $this$mapTo$iv$iv2;
                void row;
                int[] nArray = (int[])item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Collection $this$map$iv2 = row;
                boolean $i$f$map2 = false;
                void var19_19 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv2).length);
                boolean $i$f$mapTo2 = false;
                int n = ((void)$this$mapTo$iv$iv2).length;
                for (int i = 0; i < n; ++i) {
                    void cell;
                    void item$iv$iv2;
                    void var25_25 = item$iv$iv2 = $this$mapTo$iv$iv2[i];
                    Collection collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(String.valueOf($this$populateLayout_u24lambda_u243.charAt((int)cell)));
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv2;
                collection.add(thisCollection$iv.toArray(new String[0]));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return (String[][])thisCollection$iv.toArray((T[])new String[0][]);
        }

        @NotNull
        public String toString() {
            return "SingleDigitTokenizer";
        }

        public int hashCode() {
            return -877882586;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SingleDigitTokenizer)) {
                return false;
            }
            SingleDigitTokenizer cfr_ignored_0 = (SingleDigitTokenizer)other;
            return true;
        }
    }
}

