/*
 * Decompiled with CFR 0.152.
 */
package dev.teogor.sudoklify.core.solver;

import dev.teogor.sudoklify.common.model.SudokuSolution;
import dev.teogor.sudoklify.common.types.SudokuType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J)\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u001bJ3\u0010\u001c\u001a\u00020\u001a2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010 R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\n\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000ej\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f`\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/teogor/sudoklify/core/solver/SudokuSolver;", "", "grid", "", "", "sudokuType", "Ldev/teogor/sudoklify/common/types/SudokuType;", "<init>", "([[ILdev/teogor/sudoklify/common/types/SudokuType;)V", "[[I", "steps", "Lkotlin/collections/ArrayList;", "Lkotlin/Pair;", "", "Ljava/util/ArrayList;", "Ljava/util/ArrayList;", "stepCount", "solve", "Ldev/teogor/sudoklify/common/model/SudokuSolution;", "copyGrid", "", "sourceGrid", "destinationGrid", "([[I[[I)V", "([[I)[[I", "solveSudoku", "", "([[I)Z", "isValid", "row", "col", "num", "([[IIII)Z", "sudoklify-core"})
@SourceDebugExtension(value={"SMAP\nSudokuSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SudokuSolver.kt\ndev/teogor/sudoklify/core/solver/SudokuSolver\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,121:1\n79#2,5:122\n113#2,7:127\n*S KotlinDebug\n*F\n+ 1 SudokuSolver.kt\ndev/teogor/sudoklify/core/solver/SudokuSolver\n*L\n32#1:122,5\n32#1:127,7\n*E\n"})
public final class SudokuSolver {
    @NotNull
    private final int[][] grid;
    @NotNull
    private final SudokuType sudokuType;
    @NotNull
    private final ArrayList<Pair<Integer, Integer>> steps;
    private int stepCount;

    public SudokuSolver(@NotNull int[][] grid, @NotNull SudokuType sudokuType) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)sudokuType, (String)"sudokuType");
        this.grid = grid;
        this.sudokuType = sudokuType;
        this.steps = new ArrayList();
    }

    @NotNull
    public final SudokuSolution solve() {
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        int[][] workingGrid = this.copyGrid(this.grid);
        boolean solved = this.solveSudoku(workingGrid);
        if (solved) {
            this.copyGrid(workingGrid, this.grid);
        }
        SudokuSolution result$iv$iv = new SudokuSolution(0L, solved, this.stepCount, workingGrid);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        SudokuSolution value = (SudokuSolution)timedValue.component1();
        long timeTaken = timedValue.component2-UwyO8pc();
        return SudokuSolution.copy$default((SudokuSolution)value, (long)Duration.getInWholeMilliseconds-impl((long)timeTaken), (boolean)false, (int)0, null, (int)14, null);
    }

    private final void copyGrid(int[][] sourceGrid, int[][] destinationGrid) {
        int n = ((Object[])sourceGrid).length;
        for (int row = 0; row < n; ++row) {
            int n2 = sourceGrid[row].length;
            for (int col = 0; col < n2; ++col) {
                destinationGrid[row][col] = sourceGrid[row][col];
            }
        }
    }

    private final int[][] copyGrid(int[][] sourceGrid) {
        int n = 0;
        int n2 = ((Object[])sourceGrid).length;
        int[][] nArrayArray = new int[n2][];
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = new int[sourceGrid[0].length];
        }
        int[][] newGrid = nArrayArray;
        this.copyGrid(sourceGrid, newGrid);
        return newGrid;
    }

    private final boolean solveSudoku(int[][] grid) {
        int n = this.stepCount;
        this.stepCount = n + 1;
        int n2 = ((Object[])grid).length;
        for (int row = 0; row < n2; ++row) {
            int n3 = grid[row].length;
            for (int col = 0; col < n3; ++col) {
                if (grid[row][col] != 0) continue;
                int num = 1;
                int n4 = this.sudokuType.getUniqueDigitsCount();
                if (num <= n4) {
                    while (true) {
                        if (this.isValid(grid, row, col, num)) {
                            grid[row][col] = num;
                            this.steps.add((Pair<Integer, Integer>)new Pair((Object)row, (Object)col));
                            if (this.solveSudoku(grid)) {
                                return true;
                            }
                            grid[row][col] = 0;
                            CollectionsKt.removeLast((List)this.steps);
                        }
                        if (num == n4) break;
                        ++num;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private final boolean isValid(int[][] grid, int row, int col, int num) {
        int n = this.sudokuType.getTotalCells();
        for (int i = 0; i < n; ++i) {
            if (grid[row][i] != num && grid[i][col] != num) continue;
            return false;
        }
        int rowStart = row / this.sudokuType.getHeight() * this.sudokuType.getHeight();
        int colStart = col / this.sudokuType.getWidth() * this.sudokuType.getWidth();
        int n2 = rowStart + this.sudokuType.getHeight();
        for (int i = rowStart; i < n2; ++i) {
            int n3 = colStart + this.sudokuType.getWidth();
            for (int j = colStart; j < n3; ++j) {
                if (grid[i][j] != num) continue;
                return false;
            }
        }
        return true;
    }
}

