/*
 * Decompiled with CFR 0.152.
 */
package dev.teogor.sudoklify.core.io;

import dev.teogor.sudoklify.common.types.SudokuType;
import dev.teogor.sudoklify.core.io.BoardSerializationKt;
import dev.teogor.sudoklify.core.util.BoardConversionsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0002\u0010\u000fR\u001c\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/teogor/sudoklify/core/io/SudokuParser;", "", "puzzle", "", "sudokuType", "Ldev/teogor/sudoklify/common/types/SudokuType;", "<init>", "(Ljava/lang/String;Ldev/teogor/sudoklify/common/types/SudokuType;)V", "puzzleBoard", "", "[[Ljava/lang/String;", "boxDigits", "", "toIntArray", "", "()[[I", "sudoklify-core"})
public final class SudokuParser {
    @NotNull
    private final String[][] puzzleBoard;
    private final int boxDigits;

    public SudokuParser(@NotNull String puzzle, @NotNull SudokuType sudokuType) {
        Intrinsics.checkNotNullParameter((Object)puzzle, (String)"puzzle");
        Intrinsics.checkNotNullParameter((Object)sudokuType, (String)"sudokuType");
        this.puzzleBoard = BoardConversionsKt.toBoard(puzzle, sudokuType);
        this.boxDigits = sudokuType.getUniqueDigitsCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final int[][] toIntArray() {
        int n;
        Map<String, String> tokenMap = BoardSerializationKt.generateTokenMap(this.boxDigits);
        int n2 = 0;
        int n3 = ((Object[])this.puzzleBoard).length;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            n = n2++;
            nArrayArray[n] = new int[this.puzzleBoard[0].length];
        }
        int[][] convertedPuzzle = nArrayArray;
        n3 = ((Object[])this.puzzleBoard).length;
        for (int row = 0; row < n3; ++row) {
            n = this.puzzleBoard[row].length;
            for (int col = 0; col < n; ++col) {
                int n4;
                int[] nArray = convertedPuzzle[row];
                if (!Intrinsics.areEqual((Object)this.puzzleBoard[row][col], (Object)"-")) {
                    String value = this.puzzleBoard[row][col];
                    String string = tokenMap.get(value);
                    if (string == null) throw new IllegalArgumentException("Invalid token '" + value + "' found in Sudoku puzzle.");
                    n4 = Integer.parseInt(string);
                } else {
                    n4 = 0;
                }
                nArray[col] = n4;
            }
        }
        return convertedPuzzle;
    }
}

