/*
 * Decompiled with CFR 0.152.
 */
package dev.teogor.sudoklify.core.generation;

import dev.teogor.sudoklify.common.model.Sudoku;
import dev.teogor.sudoklify.common.model.SudokuBlueprint;
import dev.teogor.sudoklify.common.model.SudokuPuzzle;
import dev.teogor.sudoklify.common.types.Difficulty;
import dev.teogor.sudoklify.common.types.Seed;
import dev.teogor.sudoklify.common.types.SudokuType;
import dev.teogor.sudoklify.core.tokenizer.Tokenizer;
import dev.teogor.sudoklify.core.util.BoardConversionsKt;
import dev.teogor.sudoklify.core.util.RandomExtensionsKt;
import dev.teogor.sudoklify.ktx.BoardCellExtensionsKt;
import dev.teogor.sudoklify.ktx.SeedExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001B/\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB/\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0017\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0007J\u0006\u0010\u001d\u001a\u00020\u001eJK\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00030\u00032\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0006\u0010\"\u001a\u00020 2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0%j\u0002`$H\u0002\u00a2\u0006\u0002\u0010&J)\u0010'\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J+\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00030\u00032\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010*J)\u0010+\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J)\u0010,\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J)\u0010-\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J)\u0010.\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J)\u0010/\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J)\u00100\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J)\u00101\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J)\u00102\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J)\u00103\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(J)\u00104\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00142\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010(JV\u00105\u001a\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014062,\u00107\u001a(\u0012$\u0012\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u00140608H\u0002J#\u00109\u001a\u00020\u001c2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010:J)\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010<J)\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010>\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010?J\u001b\u00105\u001a\u00020\u00042\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010@J\u001d\u0010A\u001a\u0012\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0%j\u0002`$H\u0002\u00a2\u0006\u0002\u0010BR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00150\u0003j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Ldev/teogor/sudoklify/core/generation/SudokuGenerator;", "", "seeds", "", "Ldev/teogor/sudoklify/common/model/SudokuBlueprint;", "seed", "Ldev/teogor/sudoklify/common/types/Seed;", "sudokuType", "Ldev/teogor/sudoklify/common/types/SudokuType;", "difficulty", "Ldev/teogor/sudoklify/common/types/Difficulty;", "<init>", "([Ldev/teogor/sudoklify/common/model/SudokuBlueprint;Ldev/teogor/sudoklify/common/types/Seed;Ldev/teogor/sudoklify/common/types/SudokuType;Ldev/teogor/sudoklify/common/types/Difficulty;)V", "random", "Lkotlin/random/Random;", "([Ldev/teogor/sudoklify/common/model/SudokuBlueprint;Lkotlin/random/Random;Ldev/teogor/sudoklify/common/types/SudokuType;Ldev/teogor/sudoklify/common/types/Difficulty;)V", "[Ldev/teogor/sudoklify/common/model/SudokuBlueprint;", "boxDigits", "", "baseLayout", "Ldev/teogor/sudoklify/common/types/Layout;", "", "[[I", "tokenizer", "Ldev/teogor/sudoklify/core/tokenizer/Tokenizer;", "generateBaseLayout", "()[[I", "composeSudokuPuzzle", "Ldev/teogor/sudoklify/common/model/Sudoku;", "createPuzzle", "Ldev/teogor/sudoklify/common/model/SudokuPuzzle;", "getSequence", "", "layout", "seedSequence", "tokenMap", "Ldev/teogor/sudoklify/common/types/TokenMap;", "", "([[ILjava/lang/String;Ljava/util/Map;)[[Ljava/lang/String;", "getLayout", "([[I)[[I", "getLayoutBands", "([[I)[[[I", "rotateLayout", "rotateLayout0", "rotateLayout90", "rotateLayout180", "rotateLayout270", "shuffleLayout", "shuffleLayoutBands", "shuffleLayoutColumns", "shuffleLayoutRows", "shuffleLayoutStacks", "getRandomItem", "Lkotlin/Function1;", "items", "", "getSeed", "([Ldev/teogor/sudoklify/common/model/SudokuBlueprint;Ldev/teogor/sudoklify/common/types/Difficulty;)Ldev/teogor/sudoklify/common/model/Sudoku;", "getSeedsByDifficulty", "([Ldev/teogor/sudoklify/common/model/SudokuBlueprint;Ldev/teogor/sudoklify/common/types/Difficulty;)[Ldev/teogor/sudoklify/common/model/SudokuBlueprint;", "getSeedsBySize", "size", "([Ldev/teogor/sudoklify/common/model/SudokuBlueprint;I)[Ldev/teogor/sudoklify/common/model/SudokuBlueprint;", "([Ldev/teogor/sudoklify/common/model/SudokuBlueprint;)Ldev/teogor/sudoklify/common/model/SudokuBlueprint;", "getTokenMap", "()Ljava/util/Map;", "sudoklify-core"})
@SourceDebugExtension(value={"SMAP\nSudokuGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SudokuGenerator.kt\ndev/teogor/sudoklify/core/generation/SudokuGenerator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,277:1\n11102#2:278\n11437#2,3:279\n11102#2:295\n11437#2,3:296\n11222#2:311\n11342#2,3:312\n11102#2:315\n11437#2,3:316\n11345#2:319\n11102#2:322\n11437#2,3:323\n11222#2:328\n11342#2,3:329\n11102#2:332\n11437#2,3:333\n11345#2:336\n11102#2:347\n11437#2,3:348\n3829#2:359\n4344#2,2:360\n3829#2:364\n4344#2,2:365\n1567#3:282\n1598#3,3:283\n1567#3:286\n1598#3,4:287\n1601#3:291\n774#3:292\n865#3,2:293\n1557#3:299\n1628#3,2:300\n1557#3:302\n1628#3,3:303\n1630#3:306\n1368#3:339\n1454#3,5:340\n1368#3:351\n1454#3,5:352\n1557#3:369\n1628#3,3:370\n1187#3,2:373\n1261#3,4:375\n37#4,2:307\n37#4,2:309\n37#4,2:320\n37#4,2:326\n37#4,2:337\n37#4,2:345\n37#4,2:357\n37#4,2:362\n37#4,2:367\n*S KotlinDebug\n*F\n+ 1 SudokuGenerator.kt\ndev/teogor/sudoklify/core/generation/SudokuGenerator\n*L\n104#1:278\n104#1:279,3\n118#1:295\n118#1:296,3\n153#1:311\n153#1:312,3\n153#1:315\n153#1:316,3\n153#1:319\n157#1:322\n157#1:323,3\n160#1:328\n160#1:329,3\n160#1:332\n160#1:333,3\n160#1:336\n174#1:347\n174#1:348,3\n202#1:359\n202#1:360,2\n210#1:364\n210#1:365,2\n105#1:282\n105#1:283,3\n106#1:286\n106#1:287,4\n105#1:291\n115#1:292\n115#1:293,2\n119#1:299\n119#1:300,2\n120#1:302\n120#1:303,3\n119#1:306\n167#1:339\n167#1:340,5\n175#1:351\n175#1:352,5\n220#1:369\n220#1:370,3\n226#1:373,2\n226#1:375,4\n139#1:307,2\n142#1:309,2\n154#1:320,2\n157#1:326,2\n161#1:337,2\n168#1:345,2\n176#1:357,2\n204#1:362,2\n212#1:367,2\n*E\n"})
public final class SudokuGenerator {
    @NotNull
    private final SudokuBlueprint[] seeds;
    @NotNull
    private final Seed seed;
    @NotNull
    private final SudokuType sudokuType;
    @NotNull
    private final Difficulty difficulty;
    @NotNull
    private final Random random;
    private final int boxDigits;
    @NotNull
    private final int[][] baseLayout;
    @NotNull
    private final Tokenizer tokenizer;

    public SudokuGenerator(@NotNull SudokuBlueprint[] seeds, @NotNull Seed seed, @NotNull SudokuType sudokuType, @NotNull Difficulty difficulty) {
        Intrinsics.checkNotNullParameter((Object)seeds, (String)"seeds");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)sudokuType, (String)"sudokuType");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        this.seeds = seeds;
        this.seed = seed;
        this.sudokuType = sudokuType;
        this.difficulty = difficulty;
        this.random = this.seed.toRandom();
        this.boxDigits = this.sudokuType.getUniqueDigitsCount();
        this.baseLayout = this.generateBaseLayout();
        this.tokenizer = Tokenizer.Companion.create(this.boxDigits);
    }

    @Deprecated(message="\n      |This constructor is deprecated. Use the primary constructor\n      |`SudokuGenerator(seeds, seed, sudokuType, difficulty)` instead.\n      |", replaceWith=@ReplaceWith(expression="SudokuGenerator(seeds, seed, sudokuType, difficulty)", imports={}))
    public SudokuGenerator(@NotNull SudokuBlueprint[] seeds, @NotNull Random random, @NotNull SudokuType sudokuType, @NotNull Difficulty difficulty) {
        Intrinsics.checkNotNullParameter((Object)seeds, (String)"seeds");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)sudokuType, (String)"sudokuType");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        this(seeds, SeedExtensionsKt.createSeed((long)0L), sudokuType, difficulty);
    }

    private final int[][] generateBaseLayout() {
        int n = this.boxDigits;
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = 0;
            int n4 = this.boxDigits;
            int[] nArray = new int[n4];
            int n5 = n2;
            int[][] nArrayArray2 = nArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                nArray[n6] = n2 * this.boxDigits + n6;
            }
            nArrayArray2[n5] = nArray;
        }
        return nArrayArray;
    }

    @Deprecated(message="\n    |The composeSudokuPuzzle() method is deprecated. To create a Sudoku puzzle, use the more\n    |versatile and efficient createPuzzle() method, which returns a SudokuPuzzle object with\n    |additional features and utility methods. For compatibility with existing code,\n    |composeSudokuPuzzle() also returns a Sudoku object, but it's recommended to transition to\n    |using the richer functionality of SudokuPuzzle.\n    ", replaceWith=@ReplaceWith(expression="createPuzzle()", imports={}))
    @NotNull
    public final Sudoku composeSudokuPuzzle() {
        Sudoku seed = this.getSeed(this.seeds, this.difficulty);
        int[][] layout = this.getLayout(this.baseLayout);
        Map<String, String> tokenMap = this.getTokenMap();
        String[][] puzzle = this.getSequence(layout, BoardConversionsKt.toSequenceString(seed.getPuzzle()), tokenMap);
        String[][] solution = this.getSequence(layout, BoardConversionsKt.toSequenceString(seed.getSolution()), tokenMap);
        return new Sudoku(puzzle, solution, seed.getDifficulty(), this.sudokuType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SudokuPuzzle createPuzzle() {
        Collection<List> collection;
        Iterable $this$filterTo$iv$iv;
        Object[] $this$filter$iv;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Collection<List> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Sudoku seed = this.getSeed(this.seeds, this.difficulty);
        int[][] layout = this.getLayout(this.baseLayout);
        Map<String, String> tokenMap = this.getTokenMap();
        String[][] puzzle = this.getSequence(layout, BoardConversionsKt.toSequenceString(seed.getPuzzle()), tokenMap);
        String[][] solution = this.getSequence(layout, BoardConversionsKt.toSequenceString(seed.getSolution()), tokenMap);
        Object[] objectArray = (Object[])puzzle;
        Seed seed2 = this.seed;
        SudokuType sudokuType = seed.getSudokuType();
        Difficulty difficulty = seed.getDifficulty();
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            String[] stringArray = (String[])item$iv$iv3;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(ArraysKt.toList((Object[])it));
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = collection2;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv3 : $this$mapIndexedTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv2;
            void cols;
            int it;
            if ((it = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List bl = (List)item$iv$iv3;
            int n = it;
            collection2 = destination$iv$iv;
            boolean bl2 = false;
            Iterable $this$mapIndexed$iv2 = (Iterable)cols;
            boolean $i$f$mapIndexed2 = false;
            Iterable iterable = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
            boolean $i$f$mapIndexedTo2 = false;
            int index$iv$iv2 = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                void col;
                void row;
                void value;
                int n2;
                if ((n2 = index$iv$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv$iv2;
                int n3 = n2;
                Collection collection3 = destination$iv$iv2;
                boolean bl3 = false;
                Integer n4 = StringsKt.toIntOrNull((String)value);
                int n5 = n4 != null ? n4 : 0;
                collection3.add(new SudokuPuzzle.Givens((int)row, (int)col, n5));
            }
            collection2.add((List)destination$iv$iv2);
        }
        collection2 = (List)destination$iv$iv;
        $this$mapIndexed$iv = CollectionsKt.flatten((Iterable)collection2);
        boolean $i$f$filter = false;
        $this$mapIndexedTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SudokuPuzzle.Givens it = (SudokuPuzzle.Givens)element$iv$iv;
            boolean bl = false;
            if (!(it.getValue() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection2 = (List)destination$iv$iv;
        $this$filter$iv = (Object[])solution;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(((Iterable)$this$map$iv).length);
        $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            String[] bl = (String[])item$iv$iv3;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(ArraysKt.toList((Object[])it));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void cols;
            Object item$iv$iv3;
            item$iv$iv3 = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)cols;
            boolean $i$f$map2 = false;
            Iterable bl2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv2) {
                void value;
                String $i$f$mapIndexedTo2 = (String)item$iv$iv4;
                Collection collection4 = destination$iv$iv3;
                boolean bl5 = false;
                Integer n = StringsKt.toIntOrNull((String)value);
                collection4.add(n != null ? n : 0);
            }
            collection.add((List)destination$iv$iv3);
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 32;
        List list = null;
        Collection<List> collection5 = collection;
        Collection<List> collection6 = collection2;
        Seed seed3 = seed2;
        SudokuType sudokuType2 = sudokuType;
        Difficulty difficulty2 = difficulty;
        return new SudokuPuzzle(difficulty2, sudokuType2, seed3, collection6, collection5, list, n, defaultConstructorMarker);
    }

    private final String[][] getSequence(int[][] layout, String seedSequence, Map<String, String> tokenMap) {
        return this.tokenizer.populateLayout(layout, seedSequence, tokenMap);
    }

    private final int[][] getLayout(int[][] baseLayout) {
        return this.shuffleLayout(this.rotateLayout(baseLayout));
    }

    private final int[][][] getLayoutBands(int[][] layout) {
        int bandSize = (int)Math.sqrt(this.boxDigits);
        List bands = new ArrayList();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.boxDigits)), (int)bandSize);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                Collection $this$toTypedArray$iv = ArraysKt.slice((Object[])((Object[])layout), (IntRange)RangesKt.until((int)i, (int)(i + bandSize)));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                int[][] band = (int[][])thisCollection$iv.toArray((T[])new int[0][]);
                bands.add(band);
                if (i == n) break;
                i += n2;
            }
        }
        Collection $this$toTypedArray$iv = bands;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (int[][][])thisCollection$iv.toArray((T[])new int[0][][]);
    }

    private final int[][] rotateLayout(int[][] layout) {
        Object[] objectArray = new KFunction[]{new Function1<int[][], int[][]>((Object)this){

            public final int[][] invoke(int[][] p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SudokuGenerator.access$rotateLayout0((SudokuGenerator)this.receiver, p0);
            }
        }, new Function1<int[][], int[][]>((Object)this){

            public final int[][] invoke(int[][] p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SudokuGenerator.access$rotateLayout90((SudokuGenerator)this.receiver, p0);
            }
        }, new Function1<int[][], int[][]>((Object)this){

            public final int[][] invoke(int[][] p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SudokuGenerator.access$rotateLayout180((SudokuGenerator)this.receiver, p0);
            }
        }, new Function1<int[][], int[][]>((Object)this){

            public final int[][] invoke(int[][] p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SudokuGenerator.access$rotateLayout270((SudokuGenerator)this.receiver, p0);
            }
        }};
        return (int[][])this.getRandomItem(CollectionsKt.listOf((Object[])objectArray)).invoke((Object)layout);
    }

    private final int[][] rotateLayout0(int[][] layout) {
        return layout;
    }

    /*
     * WARNING - void declaration
     */
    private final int[][] rotateLayout90(int[][] layout) {
        void $this$mapIndexedTo$iv$iv;
        int[] $this$mapIndexed$iv = layout[0];
        boolean $i$f$mapIndexed = false;
        int[] nArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapTo$iv$iv;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] $this$map$iv = (Object[])layout;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv2 : $this$mapTo$iv$iv) {
                void index;
                void row;
                int[] nArray2 = (int[])item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add((int)row[index]);
            }
            collection.add(CollectionsKt.toIntArray((Collection)CollectionsKt.reversed((Iterable)((List)destination$iv$iv2))));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (int[][])thisCollection$iv.toArray((T[])new int[0][]);
    }

    /*
     * WARNING - void declaration
     */
    private final int[][] rotateLayout180(int[][] layout) {
        void $this$mapTo$iv$iv;
        Object[] $this$map$iv = (Object[])layout;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void row;
            int[] nArray = (int[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.toIntArray((Collection)ArraysKt.reversed((int[])row)));
        }
        Collection $this$toTypedArray$iv = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (int[][])thisCollection$iv.toArray((T[])new int[0][]);
    }

    /*
     * WARNING - void declaration
     */
    private final int[][] rotateLayout270(int[][] layout) {
        void $this$mapIndexedTo$iv$iv;
        int[] $this$mapIndexed$iv = layout[0];
        boolean $i$f$mapIndexed = false;
        int[] nArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapTo$iv$iv;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] $this$map$iv = (Object[])layout;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv2 : $this$mapTo$iv$iv) {
                void index;
                void row;
                int[] nArray2 = (int[])item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(((Number)ArraysKt.reversed((int[])row).get((int)index)).intValue());
            }
            collection.add(CollectionsKt.toIntArray((Collection)((List)destination$iv$iv2)));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (int[][])thisCollection$iv.toArray((T[])new int[0][]);
    }

    private final int[][] shuffleLayout(int[][] layout) {
        return this.shuffleLayoutColumns(this.shuffleLayoutRows(this.shuffleLayoutStacks(this.shuffleLayoutBands(layout))));
    }

    /*
     * WARNING - void declaration
     */
    private final int[][] shuffleLayoutBands(int[][] layout) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = ArraysKt.sortedWith((Object[])((Object[])this.getLayoutBands(layout)), (Comparator)new Comparator(this){
            final /* synthetic */ SudokuGenerator this$0;
            {
                this.this$0 = sudokuGenerator;
            }

            public final int compare(T a, T b) {
                int[][] it = (int[][])a;
                boolean bl = false;
                it = (int[][])b;
                Comparable comparable = Integer.valueOf(RandomExtensionsKt.sortRandom(SudokuGenerator.access$getRandom$p(this.this$0)));
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(RandomExtensionsKt.sortRandom(SudokuGenerator.access$getRandom$p(this.this$0))));
            }
        });
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            int[][] it = (int[][])element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList((Object[])((Object[])it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (int[][])thisCollection$iv.toArray((T[])new int[0][]);
    }

    private final int[][] shuffleLayoutColumns(int[][] layout) {
        return this.rotateLayout270(this.shuffleLayoutRows(this.rotateLayout90(layout)));
    }

    /*
     * WARNING - void declaration
     */
    private final int[][] shuffleLayoutRows(int[][] layout) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object[] $this$map$iv = (Object[])this.getLayoutBands(layout);
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void rows;
            int[][] nArray = (int[][])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ArraysKt.sortedWith((Object[])((Object[])rows), (Comparator)new Comparator(this){
                final /* synthetic */ SudokuGenerator this$0;
                {
                    this.this$0 = sudokuGenerator;
                }

                public final int compare(T a, T b) {
                    int[] it = (int[])a;
                    boolean bl = false;
                    it = (int[])b;
                    Comparable comparable = Integer.valueOf(RandomExtensionsKt.sortRandom(SudokuGenerator.access$getRandom$p(this.this$0)));
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(RandomExtensionsKt.sortRandom(SudokuGenerator.access$getRandom$p(this.this$0))));
                }
            }));
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.toList((Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (int[][])thisCollection$iv.toArray((T[])new int[0][]);
    }

    private final int[][] shuffleLayoutStacks(int[][] layout) {
        return this.rotateLayout270(this.shuffleLayoutBands(this.rotateLayout90(layout)));
    }

    private final Function1<int[][], int[][]> getRandomItem(List<? extends Function1<? super int[][], int[][]>> items) {
        return (Function1)CollectionsKt.first((List)CollectionsKt.shuffled((Iterable)items, (Random)this.random));
    }

    private final Sudoku getSeed(SudokuBlueprint[] seeds, Difficulty difficulty) {
        SudokuBlueprint randomItem = this.getRandomItem(this.getSeedsByDifficulty(this.getSeedsBySize(seeds, this.boxDigits), difficulty));
        return new Sudoku(BoardConversionsKt.toBoard(randomItem.getPuzzle(), this.sudokuType), BoardConversionsKt.toBoard(randomItem.getSolution(), this.sudokuType), randomItem.getDifficulty(), randomItem.getSudokuType());
    }

    /*
     * WARNING - void declaration
     */
    private final SudokuBlueprint[] getSeedsByDifficulty(SudokuBlueprint[] seeds, Difficulty difficulty) {
        void $this$filterTo$iv$iv;
        SudokuBlueprint[] $this$filter$iv = seeds;
        boolean $i$f$filter = false;
        SudokuBlueprint[] sudokuBlueprintArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void seed = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(seed.getDifficulty() == difficulty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SudokuBlueprint[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final SudokuBlueprint[] getSeedsBySize(SudokuBlueprint[] seeds, int size) {
        void $this$filterTo$iv$iv;
        SudokuBlueprint[] $this$filter$iv = seeds;
        boolean $i$f$filter = false;
        SudokuBlueprint[] sudokuBlueprintArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void seed = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(seed.getSudokuType().getUniqueDigitsCount() == size)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SudokuBlueprint[0]);
    }

    private final SudokuBlueprint getRandomItem(SudokuBlueprint[] items) {
        return items[this.random.nextInt(items.length)];
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getTokenMap() {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        IntRange gridList = new IntRange(1, this.boxDigits);
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)((Iterable)gridList));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            int value = index < this.boxDigits ? index + 1 : index - this.boxDigits + 1;
            collection.add(BoardCellExtensionsKt.toJEncodedCell((int)value));
        }
        List tokenList = CollectionsKt.shuffled((Iterable)((List)destination$iv$iv), (Random)this.random);
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)tokenList);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo22 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            String token = (String)indexedValue.component2();
            String value = index < this.boxDigits ? String.valueOf(index + 1) : String.valueOf(index - this.boxDigits + 1);
            indexedValue = TuplesKt.to((Object)token, (Object)value);
            map.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        Map tokenMap = destination$iv$iv2;
        return tokenMap;
    }

    public static final /* synthetic */ int[][] access$rotateLayout0(SudokuGenerator $this, int[][] layout) {
        return $this.rotateLayout0(layout);
    }

    public static final /* synthetic */ int[][] access$rotateLayout90(SudokuGenerator $this, int[][] layout) {
        return $this.rotateLayout90(layout);
    }

    public static final /* synthetic */ int[][] access$rotateLayout180(SudokuGenerator $this, int[][] layout) {
        return $this.rotateLayout180(layout);
    }

    public static final /* synthetic */ int[][] access$rotateLayout270(SudokuGenerator $this, int[][] layout) {
        return $this.rotateLayout270(layout);
    }

    public static final /* synthetic */ Random access$getRandom$p(SudokuGenerator $this) {
        return $this.random;
    }
}

