package temper.std.testing;
import java.util.List;
import java.util.Map.Entry;
import java.util.function.Consumer;
import temper.core.Core;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.ArrayList;
import temper.core.Core.GlobalConsole;
import java.util.AbstractMap.SimpleImmutableEntry;
public final class TestingGlobal {
    private TestingGlobal() {
    }
    static final GlobalConsole vGlobalConsole__47;
    public static final Class TestName;
    public static final Class TestFun;
    public static final Class TestCase;
    public static final Class TestFailureMessage;
    public static final Class TestResult;
    public static List<Entry<String, List<String>>> processTestCases(List<Entry<String, Consumer<Test>>> testCases__65) {
        Function<Entry<String, Consumer<Test>>, Entry<String, List<String>>> fn__274 = testCase__67 -> {
            boolean t_265;
            List<String> t_267;
            boolean t_166;
            String key__69 = testCase__67.getKey();
            Consumer<Test> fun__70 = testCase__67.getValue();
            Test test__71 = new Test();
            boolean hadBubble__72;
            boolean hadBubble_1244;
            try {
                fun__70.accept(test__71);
                hadBubble_1244 = false;
            } catch (RuntimeException ignored$1) {
                hadBubble_1244 = true;
            }
            hadBubble__72 = hadBubble_1244;
            List<String> messages__73 = test__71.messages();
            List<String> failures__74;
            if (test__71.isPassing()) {
                failures__74 = List.of();
            } else {
                if (hadBubble__72) {
                    t_265 = test__71.isFailedOnAssert();
                    t_166 = !t_265;
                } else {
                    t_166 = false;
                }
                if (t_166) {
                    List<String> allMessages__75 = new ArrayList<>(messages__73);
                    {
                        Core.listAdd(allMessages__75, "Bubble");
                        t_267 = List.copyOf(allMessages__75);
                        failures__74 = t_267;
                    }
                } else {
                    failures__74 = messages__73;
                }
            }
            return new SimpleImmutableEntry<>(key__69, failures__74);
        };
        return Core.listMapObjToObj(testCases__65, fn__274);
    }
    public static void reportTestResults(List<Entry<String, List<String>>> testResults__76) {
        int t_252;
        Entry<String, List<String>> t_152;
        int i__78 = 0;
        s__1248_1249: {
            while (true) {
                t_252 = testResults__76.size();
                if (i__78 < t_252) {
                    try {
                        t_152 = Core.listGet(testResults__76, i__78);
                    } catch (RuntimeException ignored$2) {
                        break;
                    }
                    Entry<String, List<String>> testResult__79 = t_152;
                    List<String> failureMessages__80 = testResult__79.getValue();
                    if (failureMessages__80.isEmpty()) {
                        vGlobalConsole__47.log(testResult__79.getKey() + ": Passed");
                    } else {
                        Function<String, String> fn__250 = it__82 -> {
                            return it__82;
                        };
                        String message__81 = Core.listJoinObj(failureMessages__80, ", ", fn__250);
                        vGlobalConsole__47.log(testResult__79.getKey() + ": Failed " + message__81);
                    }
                    i__78 = i__78 + 1;
                } else {
                    break s__1248_1249;
                }
            }
            throw Core.bubble();
        }
    }
    public static void runTestCases(List<Entry<String, Consumer<Test>>> testCases__83) {
        temper.std.testing.TestingGlobal.reportTestResults(temper.std.testing.TestingGlobal.processTestCases(testCases__83));
    }
    public static void runTest(Consumer<Test> testFun__85) {
        Test test__87 = new Test();
        {
            testFun__85.accept(test__87);
            test__87.softFailToHard();
        }
    }
    static {
        vGlobalConsole__47 = Core.console(Logger.getLogger("temper.std.testing"));
        TestName = String.class;
        TestFun = Consumer.class;
        TestCase = Entry.class;
        TestFailureMessage = String.class;
        TestResult = Entry.class;
    }
}
