/*
 * Decompiled with CFR 0.152.
 */
package temper.std.regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import temper.core.Core;
import temper.std.regex.Capture;
import temper.std.regex.CompiledRegex;
import temper.std.regex.Group;
import temper.std.regex.Or;
import temper.std.regex.Regex;
import temper.std.regex.RegexFormatter;
import temper.std.regex.RegexRefs;
import temper.std.regex.Repeat;
import temper.std.regex.Sequence;

class Core {
    private static final String FULL = "full";

    private Core() {
    }

    static String regexFormat(CompiledRegex regex) {
        ArrayList<String> builder = new ArrayList<String>();
        new RegexFormatter(builder).format(regex.getData());
        int size = 0;
        for (String s : builder) {
            size += s.length();
        }
        StringBuilder sb = new StringBuilder(size);
        for (String s : builder) {
            sb.append(s);
        }
        return sb.toString();
    }

    private static boolean groupNames(Regex regex, List<String> tgt) {
        boolean hasFull = false;
        if (regex instanceof Capture) {
            Capture cap = (Capture)regex;
            String name = cap.getName();
            tgt.add(name);
            hasFull = Core.groupNames(cap.getItem(), tgt) || FULL.equals(name);
        } else if (regex instanceof Or) {
            for (Regex child : ((Or)regex).getItems()) {
                hasFull |= Core.groupNames(child, tgt);
            }
        } else if (regex instanceof Sequence) {
            for (Regex child : ((Sequence)regex).getItems()) {
                hasFull |= Core.groupNames(child, tgt);
            }
        } else if (regex instanceof Repeat) {
            hasFull = Core.groupNames(((Repeat)regex).getItem(), tgt);
        }
        return hasFull;
    }

    static Object regexCompiledFormatted(CompiledRegex regex, String text) {
        Pattern pattern = Pattern.compile(text);
        ArrayList<String> names = new ArrayList<String>();
        names.add(FULL);
        boolean customFull = Core.groupNames(regex.getData(), names);
        if (customFull) {
            names.remove(0);
        }
        names.trimToSize();
        return new InternalPattern(pattern, names, customFull);
    }

    static boolean regexCompiledFound(CompiledRegex regex, Object compiled, String text) {
        return ((InternalPattern)compiled).pattern.matcher(text).find();
    }

    static Map<String, Group> regexCompiledFind(CompiledRegex regex, Object compiled, String text, RegexRefs refs) {
        InternalPattern internal = (InternalPattern)compiled;
        Matcher matcher = internal.pattern.matcher(text);
        if (!matcher.find()) {
            throw temper.core.Core.noResult();
        }
        return new ConvertGroups(internal, text).convertGroups(matcher);
    }

    static String regexCompiledReplace(CompiledRegex regex, Object compiled, String sourceText, Function<Map<String, Group>, String> replaceText, RegexRefs refs) {
        InternalPattern internal = (InternalPattern)compiled;
        Matcher matcher = internal.pattern.matcher(sourceText);
        StringBuilder sb = new StringBuilder();
        int prior = 0;
        ConvertGroups converter = new ConvertGroups(internal, sourceText);
        while (matcher.find()) {
            sb.append(sourceText, prior, matcher.start());
            prior = matcher.end();
            Map<String, Group> groupsMap = converter.convertGroups(matcher);
            String replacement = null;
            try {
                replacement = replaceText.apply(groupsMap);
            }
            catch (Core.NoResult noResult) {
                // empty catch block
            }
            if (replacement == null) continue;
            sb.append(replacement);
        }
        sb.append(sourceText, prior, sourceText.length());
        return sb.toString();
    }

    static void regexFormatterPushCodeTo(RegexFormatter ignored, List<String> out, int code, boolean insideCodeSet) {
        String result;
        switch (code) {
            case 9: {
                result = "\\t";
                break;
            }
            case 10: {
                result = "\\n";
                break;
            }
            case 13: {
                result = "\\r";
                break;
            }
            case 45: {
                result = insideCodeSet ? "\\-" : "-";
                break;
            }
            case 34: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 124: {
                result = "\\" + (char)code;
                break;
            }
            default: {
                result = code < 32 ? new Formatter().format("\\x%02x", code).toString() : (code < 127 ? Character.toString((char)code) : (code < 256 ? new Formatter().format("\\x%02x", code).toString() : new Formatter().format("\\u{%x}", code).toString()));
            }
        }
        out.add(result);
    }

    private static class ConvertGroups {
        final InternalPattern pat;
        final String text;
        int lastOffset = 0;
        int lastCodePointOffset = 0;

        ConvertGroups(InternalPattern pat, String text) {
            this.pat = pat;
            this.text = text;
        }

        Map<String, Group> convertGroups(Matcher matcher) {
            LinkedHashMap<String, Group> out = new LinkedHashMap<String, Group>(this.pat.namesPatternOrder.size() * 4 / 3 + 1, 0.75f);
            int offset = this.lastOffset;
            int codePointOffset = this.lastCodePointOffset;
            for (String name : this.pat.namesPatternOrder) {
                String value;
                int start;
                if (this.pat.customFull || !Core.FULL.equals(name)) {
                    start = matcher.start(name);
                    value = matcher.group(name);
                } else {
                    start = matcher.start(0);
                    value = matcher.group(0);
                }
                if (value == null || start < 0) {
                    out.put(name, new Group(name, "", -1));
                    continue;
                }
                codePointOffset = start >= offset ? (codePointOffset += this.text.codePointCount(offset, start)) : this.text.codePointCount(0, start);
                offset = start;
                out.put(name, new Group(name, value, codePointOffset));
            }
            this.lastOffset = offset;
            this.lastCodePointOffset = codePointOffset;
            return Collections.unmodifiableMap(out);
        }
    }

    private static class InternalPattern {
        final Pattern pattern;
        final List<String> namesPatternOrder;
        final boolean customFull;

        InternalPattern(Pattern pattern, List<String> names, boolean customFull) {
            this.pattern = pattern;
            this.namesPatternOrder = names;
            this.customFull = customFull;
        }
    }
}

