/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse.entity;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.ParserFunction;
import dev.sympho.modular_commands.utils.parse.entity.EntityRef;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Entity;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.util.NullnessUtil;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public abstract class EntityRefMentionParser<R extends EntityRef<? extends @NonNull Entity>>
implements ParserFunction<String, R> {
    private static final Pattern MENTION_PATTERN = Pattern.compile("<([^\\w\\s]{1,2}+)(\\d++)>");

    @Pure
    protected abstract boolean prefixMatches(String var1);

    @SideEffectFree
    protected abstract R makeRef(CommandContext var1, Snowflake var2);

    @Pure
    protected abstract String typeName();

    @SideEffectFree
    public @Nullable Snowflake parseId(String raw) throws InvalidArgumentException {
        Matcher matcher = MENTION_PATTERN.matcher(raw);
        if (!matcher.matches()) {
            return null;
        }
        String prefix = (String)NullnessUtil.castNonNull((Object)matcher.group(1));
        String id = (String)NullnessUtil.castNonNull((Object)matcher.group(2));
        if (!this.prefixMatches(prefix)) {
            throw new InvalidArgumentException("Not a %s mention".formatted(this.typeName()));
        }
        return Snowflake.of((String)id);
    }

    @SideEffectFree
    public @Nullable R parseRef(CommandContext context, String raw) throws InvalidArgumentException {
        Snowflake id = this.parseId(raw);
        return id == null ? null : (R)this.makeRef(context, id);
    }

    @Override
    public Mono<R> parse(CommandContext context, String raw) throws InvalidArgumentException {
        R ref = this.parseRef(context, raw);
        if (ref == null) {
            throw new InvalidArgumentException("Not a mention");
        }
        return Mono.just(ref);
    }
}

