/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse.entity;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface EntityRef<E extends @NonNull Entity> {
    @SideEffectFree
    public Mono<E> get(GatewayDiscordClient var1);

    public record MessageRef(Snowflake id, Snowflake channelId) implements EntityRef<Message>
    {
        public MessageRef(CommandContext context, Snowflake id) {
            this(id, context.channelId());
        }

        @Override
        public Mono<Message> get(GatewayDiscordClient client) {
            return client.getMessageById(this.channelId, this.id);
        }
    }

    public record ChannelRef<C extends @NonNull Channel>(Class<C> type, Snowflake id) implements EntityRef<C>
    {
        @Override
        public Mono<C> get(GatewayDiscordClient client) {
            return client.getChannelById(this.id).cast(this.type).onErrorMap(ClassCastException.class, ex -> new InvalidArgumentException("Channel must be a " + this.type.getSimpleName()));
        }

        @Override
        public String toString() {
            return new StringFormat(this.type.getSimpleName(), this.id).toString();
        }

        private record StringFormat(String type, Snowflake id) {
        }
    }

    public record RoleRef(Snowflake id, Snowflake guildId) implements EntityRef<Role>
    {
        public RoleRef(CommandContext context, Snowflake id) throws InvalidArgumentException {
            this(id, RoleRef.defaultGuild(context));
        }

        @Pure
        public static Snowflake defaultGuild(CommandContext context) throws InvalidArgumentException {
            Snowflake guild = context.guildId();
            if (guild == null) {
                throw new InvalidArgumentException("Currently in a private channel, please use a URL");
            }
            return guild;
        }

        @Pure
        public static Snowflake everyoneId(CommandContext context) throws InvalidArgumentException {
            return RoleRef.defaultGuild(context);
        }

        @Override
        public Mono<Role> get(GatewayDiscordClient client) {
            return client.getRoleById(this.guildId, this.id);
        }
    }

    public record UserRef(Snowflake id) implements EntityRef<User>
    {
        @Override
        public Mono<User> get(GatewayDiscordClient client) {
            return client.getUserById(this.id);
        }
    }
}

