/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.ParserFunction;
import dev.sympho.modular_commands.utils.parse.UrlParserUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.util.NullnessUtil;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public interface UrlParser<T>
extends ParserFunction<String, T> {
    public static final @Regex(value=1) Pattern MASKED_URL_PATTERN = Pattern.compile("\\[.*\\]\\(([^\\[\\]]+?)\\)");

    public static <T> UrlParser<T> choice(Function<URL, @Nullable UrlParser<T>> parserMapper) {
        return new Choice<T>(parserMapper);
    }

    public static <T> UrlParser<T> choice(Collection<? extends UrlParser<T>> parsers) {
        return UrlParser.choice(UrlParserUtils.toMapper(parsers));
    }

    @SafeVarargs
    public static <T> UrlParser<T> choice(UrlParser<T> ... parsers) {
        return UrlParser.choice(Arrays.asList(parsers));
    }

    public static <T> UrlParser<T> choiceHost(Map<String, ? extends UrlParser<T>> parsers) {
        return UrlParser.choice(UrlParserUtils.toHostMapper(parsers));
    }

    @SideEffectFree
    public static String stripFormatting(String raw) {
        Matcher match = MASKED_URL_PATTERN.matcher(raw.trim());
        if (match.matches()) {
            raw = (String)NullnessUtil.castNonNull((Object)match.group(1));
        }
        if (raw.startsWith("<") && raw.endsWith(">")) {
            raw = raw.substring(1, raw.length() - 1);
        }
        return raw;
    }

    @SideEffectFree
    public static URL getUrl(String raw) throws InvalidArgumentException {
        try {
            return new URL(raw);
        }
        catch (MalformedURLException e) {
            throw new InvalidArgumentException("Not a valid URL: " + raw, e);
        }
    }

    @SideEffectFree
    public static @Nullable URL parseUrl(String raw, Collection<String> allowedProtocols) throws InvalidArgumentException {
        String clean = UrlParser.stripFormatting(raw);
        int sep = clean.indexOf("://");
        if (sep <= 0) {
            return null;
        }
        String protocol = clean.substring(0, sep);
        if (!allowedProtocols.contains(protocol)) {
            return null;
        }
        return UrlParser.getUrl(clean);
    }

    @SideEffectFree
    public static @Nullable URL parseUrl(String raw, String allowedProtocol) throws InvalidArgumentException {
        return UrlParser.parseUrl(raw, List.of(allowedProtocol));
    }

    @Pure
    public boolean supports(URL var1);

    @Override
    @SideEffectFree
    public Mono<T> parse(CommandContext var1, URL var2) throws InvalidArgumentException;

    @Override
    default public Mono<T> parse(CommandContext context, String raw) throws InvalidArgumentException {
        return this.parse(context, UrlParser.getUrl(UrlParser.stripFormatting(raw)));
    }

    @SideEffectFree
    default public <V> UrlParser<V> then(ParserFunction<T, V> after) {
        return new PostParser(this, after);
    }

    public static class Choice<T>
    extends ChoiceBase<T, UrlParser<T>> {
        public Choice(Function<URL, @Nullable UrlParser<T>> parserMapper) {
            super(parserMapper);
        }
    }

    public static class PostParser<I, T, P1 extends @NonNull UrlParser<I>, P2 extends @NonNull ParserFunction<I, T>>
    extends ParserFunction.PostParser<String, I, T, P1, P2>
    implements UrlParser<T> {
        public PostParser(P1 parser, P2 postParser) {
            super(parser, postParser);
        }

        @Override
        public boolean supports(URL url) {
            return ((UrlParser)this.parser).supports(url);
        }

        @Override
        public Mono<T> parse(CommandContext context, URL url) throws InvalidArgumentException {
            return ((UrlParser)this.parser).parse(context, url).flatMap(i -> this.postParser.parse(context, i));
        }
    }

    public static abstract class ChoiceBase<T, P extends UrlParser<T>>
    implements UrlParser<T> {
        private final Function<URL, @Nullable P> parserMapper;

        protected ChoiceBase(Function<URL, @Nullable P> parserMapper) {
            this.parserMapper = parserMapper;
        }

        @Override
        public boolean supports(URL url) {
            UrlParser parser = (UrlParser)this.parserMapper.apply(url);
            return parser != null && parser.supports(url);
        }

        @Pure
        protected P getParser(URL url) throws InvalidArgumentException {
            UrlParser parser = (UrlParser)this.parserMapper.apply(url);
            if (parser == null) {
                throw new InvalidArgumentException("Unsupported URL: " + url);
            }
            return (P)parser;
        }

        @Override
        public Mono<T> parse(CommandContext context, URL url) throws InvalidArgumentException {
            return this.getParser(url).parse(context, url);
        }
    }
}

