/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.context;

import com.google.common.collect.Streams;
import dev.sympho.bot_utils.access.AccessManager;
import dev.sympho.bot_utils.event.reply.ReplyManager;
import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.context.MessageCommandContext;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.command.parameter.parse.ArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InputParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.SnowflakeParser;
import dev.sympho.modular_commands.api.command.parameter.parse.StringParser;
import dev.sympho.modular_commands.api.command.result.CommandFailureArgumentExtra;
import dev.sympho.modular_commands.api.exception.ResultException;
import dev.sympho.modular_commands.execute.LazyContext;
import dev.sympho.modular_commands.execute.Metrics;
import dev.sympho.modular_commands.impl.context.ContextImpl;
import dev.sympho.modular_commands.utils.StringSplitter;
import dev.sympho.modular_commands.utils.parse.RawParser;
import discord4j.common.util.Snowflake;
import discord4j.core.event.domain.message.MessageCreateEvent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MessageContextImpl
extends ContextImpl<String, MessageCreateEvent>
implements MessageCommandContext {
    private final StringSplitter.Async.Iterator arguments;
    private final String argString;
    private @MonotonicNonNull List<String> inputArgsList;
    private @MonotonicNonNull Map<String, String> inputArgs;
    private @MonotonicNonNull Map<String, Attachment> attachmentArgs;

    public MessageContextImpl(MessageCreateEvent event, Invocation invocation, Command<?> command, StringSplitter.Async.Iterator args, AccessManager accessManager, ReplyManager replyManager) throws ResultException {
        super(event, invocation, command, accessManager, replyManager);
        this.arguments = args;
        this.argString = args.remainder();
    }

    @SideEffectFree
    private static <T> Map<String, T> assign(List<? extends Parameter<?>> parameters, List<T> arguments, Function<T, String> toString) throws ResultException {
        if (arguments.size() > parameters.size()) {
            List<String> extra = arguments.stream().skip(parameters.size()).map(toString).toList();
            throw new ResultException(new CommandFailureArgumentExtra(extra));
        }
        return Streams.zip(parameters.stream().map(Parameter::name), arguments.stream(), Map::entry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @SideEffectFree
    private static Flux<String> adjustArgs(List<Parameter<?>> parameters, StringSplitter.Async.Iterator args) {
        StringParser p;
        if (parameters.isEmpty()) {
            return Flux.empty();
        }
        int lastIdx = parameters.size() - 1;
        ArgumentParser<?, ?> last = parameters.get(lastIdx).parser();
        boolean merge = last instanceof StringParser && (p = (StringParser)last).allowMerge();
        AtomicInteger index = new AtomicInteger(0);
        return Flux.generate(sink -> {
            if (!args.hasNext()) {
                sink.complete();
            } else if (merge && index.getAndIncrement() == lastIdx) {
                sink.next((Object)args.remainder());
                sink.complete();
            } else {
                sink.next((Object)((String)args.next()));
            }
        });
    }

    @Override
    protected Mono<Void> initArgs() {
        return Mono.defer(() -> {
            List<Parameter<?>> inputParams = this.command.parameters().stream().filter(p -> p.parser() instanceof InputParser).toList();
            List<Parameter> attachmentParams = this.command.parameters().stream().filter(p -> p.parser() instanceof AttachmentParser).toList();
            List attachments = ((MessageCreateEvent)this.event()).getMessage().getAttachments();
            this.attachmentArgs = MessageContextImpl.assign(attachmentParams, attachments, Attachment::getFilename);
            return MessageContextImpl.adjustArgs(inputParams, this.arguments).collectList().map(Collections::unmodifiableList).doOnNext(args -> {
                this.inputArgsList = args;
            }).map(args -> MessageContextImpl.assign(inputParams, args, Function.identity())).map(Collections::unmodifiableMap).doOnNext(args -> {
                this.inputArgs = args;
            }).then();
        });
    }

    @Override
    public Metrics.Tag.Type tagType() {
        return Metrics.Tag.Type.MESSAGE;
    }

    private Map<String, String> getInputArgs() {
        return Objects.requireNonNullElse(this.inputArgs, Collections.emptyMap());
    }

    private Map<String, Attachment> getAttachmentArgs() {
        return Objects.requireNonNullElse(this.attachmentArgs, Collections.emptyMap());
    }

    private <P> Mono<P> parse(String name, RawParser<P> parser) {
        String raw = this.getInputArgs().get(name);
        return raw == null ? Mono.empty() : parser.parse(raw);
    }

    @Override
    protected Mono<String> getStringArgument(String name) {
        return this.parse(name, RawParser.STRING);
    }

    @Override
    protected Mono<Boolean> getBooleanArgument(String name) {
        return this.parse(name, RawParser.BOOLEAN);
    }

    @Override
    protected Mono<Long> getIntegerArgument(String name) throws InvalidArgumentException {
        return this.parse(name, RawParser.INTEGER);
    }

    @Override
    protected Mono<Double> getFloatArgument(String name) throws InvalidArgumentException {
        return this.parse(name, RawParser.FLOAT);
    }

    @Override
    protected Mono<Snowflake> getSnowflakeArgument(String name, SnowflakeParser.Type type) throws InvalidArgumentException {
        return this.parse(name, switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SnowflakeParser.Type.ANY -> RawParser.SNOWFLAKE;
            case SnowflakeParser.Type.CHANNEL -> RawParser.channelId(this);
            case SnowflakeParser.Type.MESSAGE -> RawParser.messageId(this);
            case SnowflakeParser.Type.ROLE -> RawParser.roleId(this);
            case SnowflakeParser.Type.USER -> RawParser.userId(this);
        });
    }

    @Override
    protected Mono<User> getUserArgument(String name) {
        return this.parse(name, RawParser.user(this));
    }

    @Override
    protected Mono<Role> getRoleArgument(String name) {
        return this.parse(name, RawParser.role(this));
    }

    @Override
    protected <C extends Channel> Mono<C> getChannelArgument(String name, Class<C> type) {
        return this.parse(name, RawParser.channel(this, type));
    }

    @Override
    protected Mono<Attachment> getAttachmentArgument(String name) {
        Attachment attachment = this.getAttachmentArgs().get(name);
        return attachment == null ? Mono.empty() : Mono.just((Object)attachment);
    }

    @Override
    public String argString() {
        return this.argString;
    }

    @Override
    public List<String> rawArgs() {
        if (this.inputArgsList == null) {
            throw LazyContext.notLoadedError();
        }
        return this.inputArgsList;
    }

    @Override
    public Map<String, String> rawArgMap() {
        if (this.inputArgs == null) {
            throw LazyContext.notLoadedError();
        }
        return this.inputArgs;
    }
}

