/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sympho.bot_utils.access.AccessManager;
import dev.sympho.modular_commands.api.registry.Registry;
import dev.sympho.modular_commands.execute.AliasProvider;
import dev.sympho.modular_commands.execute.MessageCommandExecutor;
import dev.sympho.modular_commands.execute.PrefixProvider;
import discord4j.core.GatewayDiscordClient;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="dev.sympho.modular_commands.execute.MessageCommandExecutor", generator="Immutables")
@NotThreadSafe
public final class MessageCommandExecutorBuilder {
    private static final long INIT_BIT_CLIENT = 1L;
    private static final long INIT_BIT_REGISTRY = 2L;
    private static final long INIT_BIT_PREFIX_PROVIDER = 4L;
    private long initBits = 7L;
    @Nullable
    private GatewayDiscordClient client;
    @Nullable
    private Registry registry;
    private Optional<AccessManager> accessManager = Optional.empty();
    private Optional<MeterRegistry> meters = Optional.empty();
    private Optional<ObservationRegistry> observations = Optional.empty();
    @Nullable
    private PrefixProvider prefixProvider;
    private Optional<AliasProvider> aliases = Optional.empty();

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder client(GatewayDiscordClient client) {
        this.client = Objects.requireNonNull(client, "client");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder registry(Registry registry) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder accessManager(AccessManager accessManager) {
        this.accessManager = Optional.of(accessManager);
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder accessManager(Optional<? extends AccessManager> accessManager) {
        this.accessManager = Objects.requireNonNull(accessManager, "accessManager");
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder meters(MeterRegistry meters) {
        this.meters = Optional.of(meters);
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder meters(Optional<? extends MeterRegistry> meters) {
        this.meters = Objects.requireNonNull(meters, "meters");
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder observations(ObservationRegistry observations) {
        this.observations = Optional.of(observations);
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder observations(Optional<? extends ObservationRegistry> observations) {
        this.observations = Objects.requireNonNull(observations, "observations");
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder prefixProvider(PrefixProvider prefixProvider) {
        this.prefixProvider = Objects.requireNonNull(prefixProvider, "prefixProvider");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder aliases(AliasProvider aliases) {
        this.aliases = Optional.of(aliases);
        return this;
    }

    @CanIgnoreReturnValue
    public final MessageCommandExecutorBuilder aliases(Optional<? extends AliasProvider> aliases) {
        this.aliases = Objects.requireNonNull(aliases, "aliases");
        return this;
    }

    public MessageCommandExecutor build() {
        this.checkRequiredAttributes();
        return new MessageCommandExecutor(this.client, this.registry, this.accessManager, this.meters, this.observations, this.prefixProvider, this.aliases);
    }

    private boolean clientIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean registryIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean prefixProviderIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.clientIsSet()) {
            attributes.add("client");
        }
        if (!this.registryIsSet()) {
            attributes.add("registry");
        }
        if (!this.prefixProviderIsSet()) {
            attributes.add("prefixProvider");
        }
        return "Cannot build MessageCommandExecutor, some of required attributes are not set " + attributes;
    }
}

