/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.util.annotation.Nullable;

public abstract class CommandExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private Disposable live;

    protected CommandExecutor() {
    }

    @SideEffectFree
    protected abstract Flux<?> buildPipeline();

    public synchronized boolean start() {
        if (this.live != null) {
            return false;
        }
        this.logger.info("Starting command executor");
        this.live = this.buildPipeline().subscribe();
        return true;
    }

    public synchronized boolean stop() {
        if (this.live == null) {
            return false;
        }
        this.logger.info("Stopping command executor");
        this.live.dispose();
        this.live = null;
        return true;
    }
}

